/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.fields;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.component.textfield.AbstractNumberField;
import com.vaadin.flow.component.textfield.AbstractNumberFieldI18n;
import com.vaadin.flow.component.textfield.TextFieldVariant;
import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;

@Tag(value="vaadin-integer-field")
public class LongField
extends AbstractNumberField<LongField, Long>
implements HasThemeVariant<TextFieldVariant> {
    private static final SerializableFunction<String, Long> PARSER = (SerializableFunction & Serializable)valueFormClient -> {
        if (valueFormClient == null || valueFormClient.isEmpty()) {
            return null;
        }
        try {
            return Long.parseLong(valueFormClient);
        }
        catch (NumberFormatException e) {
            return null;
        }
    };
    private static final SerializableFunction<Long, String> FORMATTER = (SerializableFunction & Serializable)valueFromModel -> valueFromModel == null ? "" : valueFromModel.toString();

    public LongField() {
        super(PARSER, FORMATTER, -9.223372036854776E18, 9.223372036854776E18);
    }

    public LongField(String label) {
        this();
        this.setLabel(label);
    }

    public LongField(String label, String placeholder) {
        this(label);
        this.setPlaceholder(placeholder);
    }

    public LongField(HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<LongField, Long>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    public LongField(String label, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<LongField, Long>> listener) {
        this(label);
        this.addValueChangeListener(listener);
    }

    public LongField(String label, Long initialValue, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<LongField, Long>> listener) {
        this(label);
        this.setValue(initialValue);
        this.addValueChangeListener(listener);
    }

    public void setErrorMessage(String errorMessage) {
        super.setErrorMessage(errorMessage);
    }

    public void setRequiredIndicatorVisible(boolean required) {
        super.setRequiredIndicatorVisible(required);
    }

    public void setMin(long min) {
        super.setMin((double)min);
    }

    public long getMin() {
        return (long)this.getMinDouble();
    }

    public void setMax(long max) {
        super.setMax((double)max);
    }

    public long getMax() {
        return (long)this.getMaxDouble();
    }

    public void setStep(int step) {
        if (step <= 0) {
            throw new IllegalArgumentException("The step cannot be less or equal to zero.");
        }
        super.setStep((double)step);
    }

    public int getStep() {
        return (int)this.getStepDouble();
    }

    public LongFieldI18n getI18n() {
        return (LongFieldI18n)super.getI18n();
    }

    public void setI18n(LongFieldI18n i18n) {
        super.setI18n((AbstractNumberFieldI18n)i18n);
    }

    public static class LongFieldI18n
    implements AbstractNumberFieldI18n {
        private String requiredErrorMessage;
        private String badInputErrorMessage;
        private String minErrorMessage;
        private String maxErrorMessage;
        private String stepErrorMessage;

        public String getBadInputErrorMessage() {
            return this.badInputErrorMessage;
        }

        public LongFieldI18n setBadInputErrorMessage(String errorMessage) {
            this.badInputErrorMessage = errorMessage;
            return this;
        }

        public String getRequiredErrorMessage() {
            return this.requiredErrorMessage;
        }

        public LongFieldI18n setRequiredErrorMessage(String errorMessage) {
            this.requiredErrorMessage = errorMessage;
            return this;
        }

        public String getMinErrorMessage() {
            return this.minErrorMessage;
        }

        public LongFieldI18n setMinErrorMessage(String errorMessage) {
            this.minErrorMessage = errorMessage;
            return this;
        }

        public String getMaxErrorMessage() {
            return this.maxErrorMessage;
        }

        public LongFieldI18n setMaxErrorMessage(String errorMessage) {
            this.maxErrorMessage = errorMessage;
            return this;
        }

        public String getStepErrorMessage() {
            return this.stepErrorMessage;
        }

        public LongFieldI18n setStepErrorMessage(String errorMessage) {
            this.stepErrorMessage = errorMessage;
            return this;
        }
    }
}

