/*
 * Decompiled with CFR 0.152.
 */
package fr.pilato.spring.elasticsearch.xml;

import fr.pilato.spring.elasticsearch.ElasticsearchNodeFactoryBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class NodeBeanDefinitionParser
implements BeanDefinitionParser {
    protected static final Log logger = LogFactory.getLog(NodeBeanDefinitionParser.class);

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        GenericBeanDefinition bdef = new GenericBeanDefinition();
        bdef.setBeanClass(ElasticsearchNodeFactoryBean.class);
        String id = element.getAttribute("id");
        String name = element.getAttribute("name");
        String settingsFile = element.getAttribute("settingsFile");
        String properties = element.getAttribute("properties");
        BeanDefinition node = NodeBeanDefinitionParser.buildNodeDef(settingsFile, properties);
        if (id != null && id.length() > 0) {
            parserContext.getRegistry().registerBeanDefinition(id, node);
        } else {
            parserContext.getRegistry().registerBeanDefinition(name, node);
        }
        return bdef;
    }

    public static BeanDefinition buildNodeDef(String settingsFile, String properties) {
        BeanDefinitionBuilder nodeFactory = BeanDefinitionBuilder.rootBeanDefinition(ElasticsearchNodeFactoryBean.class);
        if (settingsFile != null && settingsFile.length() > 0) {
            logger.warn((Object)"settingsFile is deprecated. Use properties attribute instead. See issue #15: https://github.com/dadoonet/spring-elasticsearch/issues/15.");
            nodeFactory.addPropertyValue("settingsFile", (Object)settingsFile);
        }
        if (properties != null && properties.length() > 0) {
            nodeFactory.addPropertyReference("properties", properties);
        }
        return nodeFactory.getBeanDefinition();
    }
}

