/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web.actions.data.level2;

import fr.ird.t3.actions.data.level2.Level2Configuration;
import fr.ird.t3.entities.reference.Country;
import fr.ird.t3.entities.reference.CountryDAO;
import fr.ird.t3.entities.reference.SchoolType;
import fr.ird.t3.entities.reference.SchoolTypeDAO;
import fr.ird.t3.services.ioc.InjectDAO;
import fr.ird.t3.services.ioc.InjectDecoratedBeans;
import fr.ird.t3.web.actions.AbstractConfigureAction;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ConfigureLevel2Step2Action
extends AbstractConfigureAction<Level2Configuration> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ConfigureLevel2Step2Action.class);
    @InjectDAO(entityType=Country.class)
    protected transient CountryDAO countryDAO;
    @InjectDAO(entityType=SchoolType.class)
    protected transient SchoolTypeDAO schoolTypeDAO;
    @InjectDecoratedBeans(beanType=Country.class)
    protected Map<String, String> sampleFleets;
    @InjectDecoratedBeans(beanType=Country.class)
    protected Map<String, String> sampleFlags;
    protected final Map<String, String> timeSteps = this.createTimeSteps();
    protected boolean missingDatas;

    public ConfigureLevel2Step2Action() {
        super(Level2Configuration.class);
    }

    public void prepare() throws Exception {
        float stratumWeightRatio;
        Integer stratumMinimumSampleCountObjectSchoolType;
        Level2Configuration conf = (Level2Configuration)this.getConfiguration();
        this.injectExcept(new Class[]{InjectDecoratedBeans.class});
        this.missingDatas = false;
        String oceanId = conf.getOceanId();
        conf.setSampleFlags(this.sortToList((Collection)this.countryDAO.findAllFlagUsedInSample(oceanId)));
        conf.setSampleFleets(this.sortToList((Collection)this.countryDAO.findAllFleetUsedInSample(oceanId)));
        if (CollectionUtils.isEmpty((Collection)conf.getSampleFlags())) {
            this.addFieldError("configuration.sampleFleetIds", this._("t3.error.no.sample.fleet.found", new Object[0]));
            this.missingDatas = true;
        }
        if (CollectionUtils.isEmpty((Collection)conf.getSampleFleets())) {
            this.addFieldError("configuration.sampleFlagIds", this._("t3.error.no.sample.flag.found", new Object[0]));
            this.missingDatas = true;
        }
        this.injectOnly(new Class[]{InjectDecoratedBeans.class});
        Integer stratumMinimumSampleCountFreeSchoolType = conf.getStratumMinimumSampleCountFreeSchoolType();
        if (stratumMinimumSampleCountFreeSchoolType == null) {
            SchoolType schoolType = this.schoolTypeDAO.findByCode(2);
            stratumMinimumSampleCountFreeSchoolType = schoolType.getThresholdNumberLevel2();
            conf.setStratumMinimumSampleCountFreeSchoolType(stratumMinimumSampleCountFreeSchoolType);
        }
        if ((stratumMinimumSampleCountObjectSchoolType = conf.getStratumMinimumSampleCountObjectSchoolType()) == null) {
            SchoolType schoolType = this.schoolTypeDAO.findByCode(1);
            stratumMinimumSampleCountObjectSchoolType = schoolType.getThresholdNumberLevel2();
            conf.setStratumMinimumSampleCountObjectSchoolType(stratumMinimumSampleCountObjectSchoolType);
        }
        if ((stratumWeightRatio = conf.getStratumWeightRatio()) == 0.0f) {
            stratumWeightRatio = ConfigureLevel2Step2Action.getApplicationConfig().getStratumWeightRatio().floatValue();
            conf.setStratumWeightRatio(stratumWeightRatio);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Selected sample fleet countries  : " + conf.getSampleFleetIds()));
            log.info((Object)("Selected sample fleet countries  : " + conf.getSampleFlagIds()));
            log.info((Object)("Selected min sample count BL     : " + conf.getStratumMinimumSampleCountFreeSchoolType()));
            log.info((Object)("Selected min sample count BO     : " + conf.getStratumMinimumSampleCountObjectSchoolType()));
            log.info((Object)("Selected weight ratio            : " + conf.getStratumWeightRatio()));
        }
    }

    public void validate() {
        Level2Configuration config = (Level2Configuration)this.getConfiguration();
        if (CollectionUtils.isEmpty((Collection)config.getSampleFlagIds())) {
            this.addFieldError("configuration.sampleFlagIds", this._("t3.error.no.sample.flag.selected", new Object[0]));
        }
        if (CollectionUtils.isEmpty((Collection)config.getSampleFleetIds())) {
            this.addFieldError("configuration.sampleFleetIds", this._("t3.error.no.sample.fleet.selected", new Object[0]));
        }
    }

    public String execute() throws Exception {
        Level2Configuration config = (Level2Configuration)this.getConfiguration();
        config.setValidStep2(true);
        return "success";
    }

    public Map<String, String> getSampleFleets() {
        return this.sampleFleets;
    }

    public Map<String, String> getSampleFlags() {
        return this.sampleFlags;
    }

    public Map<String, String> getTimeSteps() {
        return this.timeSteps;
    }

    public boolean isMissingDatas() {
        return this.missingDatas;
    }
}

