/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.tools.db.reference;

import fr.ird.t3.entities.T3EntityHelper;
import fr.ird.t3.entities.reference.LengthWeightConversion;
import fr.ird.t3.entities.reference.LengthWeightConversionDAO;
import fr.ird.t3.entities.reference.Ocean;
import fr.ird.t3.entities.reference.Species;
import fr.ird.t3.services.ioc.InjectDAO;
import fr.ird.t3.services.ioc.InjectFromDAO;
import fr.ird.t3.tools.db.reference.AbstractReferenceImporter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaException;

public class LengthWeightConversionImporter
extends AbstractReferenceImporter<LengthWeightConversion> {
    private static final Log log = LogFactory.getLog(LengthWeightConversionImporter.class);
    public static final String DEFAULT_TO_WEIGHT_RELATION = "a * Math.pow(L, b)";
    public static final String DEFAULT_TO_LENGTH_RELATION = "Math.pow(P/a, 1/b)";
    @InjectDAO(entityType=LengthWeightConversion.class)
    protected LengthWeightConversionDAO dao;
    @InjectFromDAO(entityType=Ocean.class)
    protected List<Ocean> oceans;
    @InjectFromDAO(entityType=Species.class)
    protected List<Species> species;
    protected Map<Integer, Ocean> oceanByCode;
    protected Map<String, Species> specieByCodeFAO;
    protected Date creationDate;

    @Override
    protected void before() throws TopiaException {
        if (CollectionUtils.isEmpty(this.oceans)) {
            throw new IllegalStateException("No ocean found in db.");
        }
        if (CollectionUtils.isEmpty(this.species)) {
            throw new IllegalStateException("No species found in db.");
        }
        this.oceanByCode = T3EntityHelper.splitBycode(this.oceans);
        this.specieByCodeFAO = T3EntityHelper.splitByCodeFAO(this.species);
        Calendar calendar = Calendar.getInstance();
        calendar.set(2, 1);
        calendar.set(1, 1970);
        calendar.set(6, 0);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        this.creationDate = calendar.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<LengthWeightConversion> loadFile(File inputFile) throws TopiaException, IOException {
        ArrayList<LengthWeightConversion> result = new ArrayList<LengthWeightConversion>();
        LineNumberReader reader = new LineNumberReader(new FileReader(inputFile));
        try {
            String line;
            reader.readLine();
            while ((line = reader.readLine()) != null) {
                String[] cells;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Incoming line : " + line));
                }
                int lineNumber = reader.getLineNumber();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("At Line [" + lineNumber + "] Data line to treat : " + line));
                }
                if ((cells = line.split(";")).length != 3) {
                    throw new IllegalStateException("At line [" + lineNumber + "], data line must have 4 cells but had here " + cells.length);
                }
                this.loadLine(result, lineNumber, cells);
            }
        }
        finally {
            reader.close();
        }
        return result;
    }

    protected void loadLine(List<LengthWeightConversion> result, int lineNumber, String[] cells) throws TopiaException {
        long nb;
        int oceanCode = this.convertToInt(cells, lineNumber, 0);
        Ocean ocean = this.getOcean(this.oceanByCode, oceanCode, lineNumber);
        String specieCodeFAO = cells[1];
        Species species = this.specieByCodeFAO.get(specieCodeFAO);
        if (species != null && (nb = this.dao.countByQuery("SELECT COUNT(*) FROM LengthWeightConversionImpl WHERE ocean = :ocean AND species = :species", new Object[]{"ocean", ocean, "species", species})) == 0L) {
            String coefficients = cells[2];
            LengthWeightConversion lengthWeightConversion = (LengthWeightConversion)this.dao.create(new Object[]{"ocean", ocean, "species", species, "coefficients", coefficients, "toLengthRelation", DEFAULT_TO_LENGTH_RELATION, "toWeightRelation", DEFAULT_TO_WEIGHT_RELATION, "beginDate", this.creationDate});
            result.add(lengthWeightConversion);
        }
    }
}

