/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.application.web.controller;

import com.google.common.collect.ImmutableMap;
import fr.ird.observe.application.web.configuration.db.InvalidObserveWebDatabaseException;
import fr.ird.observe.application.web.configuration.db.InvalidObserveWebDatabaseRoleException;
import fr.ird.observe.application.web.configuration.db.InvalidObserveWebDatabasesException;
import fr.ird.observe.application.web.configuration.db.ObserveWebDatabases;
import fr.ird.observe.application.web.configuration.db.ObserveWebDatabasesHelper;
import fr.ird.observe.application.web.configuration.user.InvalidObserveWebUserException;
import fr.ird.observe.application.web.configuration.user.InvalidObserveWebUserPermissionException;
import fr.ird.observe.application.web.configuration.user.InvalidObserveWebUsersException;
import fr.ird.observe.application.web.configuration.user.ObserveWebUsers;
import fr.ird.observe.application.web.configuration.user.ObserveWebUsersHelper;
import fr.ird.observe.application.web.controller.ObserveWebMotionController;
import fr.ird.observe.application.web.security.ObserveWebSecurityApplicationContext;
import fr.ird.observe.services.configuration.ObserveDataSourceConfigurationAndConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.debux.webmotion.server.WebMotionContextable;
import org.debux.webmotion.server.render.RenderContent;

public class ConfigurationController
extends ObserveWebMotionController {
    public void setContextable(WebMotionContextable contextable) {
        super.setContextable(contextable);
        this.getRequestContext().checkAdminApiKeyIsValid();
    }

    protected RenderContent toTextPlain(String content) {
        return (RenderContent)this.renderContent(content, "text/plain");
    }

    public RenderContent home() throws IOException {
        ObserveWebDatabases databases;
        StringBuilder builder = new StringBuilder();
        String content = this.getApplicationConfiguration().getConfigurationDescription();
        builder.append("\n~~~ Configuration         ~~~\n").append(content);
        try (StringWriter writer = new StringWriter();){
            ObserveWebDatabasesHelper observeWebDatabasesHelper = new ObserveWebDatabasesHelper();
            databases = this.getApplicationContext().getDatabases();
            observeWebDatabasesHelper.store(databases, (Writer)writer);
            writer.flush();
            builder.append("\n~~~ Databases         ~~~\n").append(writer.toString());
        }
        writer = new StringWriter();
        var3_3 = null;
        try {
            ObserveWebUsersHelper observeWebUsersHelper = new ObserveWebUsersHelper();
            databases = this.getApplicationContext().getUsers();
            observeWebUsersHelper.store((ObserveWebUsers)databases, (Writer)writer);
            writer.flush();
            builder.append("\n~~~ Users         ~~~\n").append(writer.toString());
        }
        catch (Throwable observeWebUsersHelper) {
            var3_3 = observeWebUsersHelper;
            throw observeWebUsersHelper;
        }
        finally {
            if (writer != null) {
                if (var3_3 != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable observeWebUsersHelper) {
                        var3_3.addSuppressed(observeWebUsersHelper);
                    }
                } else {
                    writer.close();
                }
            }
        }
        ObserveWebSecurityApplicationContext securityApplicationContext = this.getSecurityApplicationContext();
        StringBuilder tokens = new StringBuilder();
        ImmutableMap cache = securityApplicationContext.getConfigurationByAuthenticationToken();
        tokens.append("Number of authentication tokens: ").append(cache.size());
        for (Map.Entry entry : cache.entrySet()) {
            tokens.append("\n").append((String)entry.getKey()).append(" - ").append(((ObserveDataSourceConfigurationAndConnection)entry.getValue()).getConfiguration());
        }
        builder.append("\n~~~ AuthenticationTokens         ~~~\n").append(tokens.toString());
        var3_3 = null;
        try (InputStream mappingUrl = this.getClass().getResourceAsStream("/mapping");){
            String content2 = IOUtils.toString((InputStream)mappingUrl, (Charset)StandardCharsets.UTF_8);
            builder.append("\n~~~ Mapping         ~~~\n").append(content2);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        return this.toTextPlain(builder.toString());
    }

    public RenderContent resetAuthenticationTokens() {
        ObserveWebSecurityApplicationContext securityApplicationContext = this.getSecurityApplicationContext();
        StringBuilder builder = new StringBuilder();
        ImmutableMap authenticationTokensCache = securityApplicationContext.getConfigurationByAuthenticationToken();
        builder.append("Number of authentication tokens to reset: ").append(authenticationTokensCache.size());
        for (Map.Entry entry : authenticationTokensCache.entrySet()) {
            builder.append("\n").append((String)entry.getKey()).append(" - ").append(((ObserveDataSourceConfigurationAndConnection)entry.getValue()).getConfiguration());
        }
        for (String authenticationToken : authenticationTokensCache.keySet()) {
            securityApplicationContext.invalidateAuthenticationToken(authenticationToken);
        }
        return this.toTextPlain(builder.toString());
    }

    public RenderContent reloadConfiguration() throws IOException, InvalidObserveWebUserPermissionException, InvalidObserveWebDatabaseException, InvalidObserveWebDatabasesException, InvalidObserveWebDatabaseRoleException, InvalidObserveWebUsersException, InvalidObserveWebUserException {
        ObserveWebSecurityApplicationContext securityApplicationContext = this.getSecurityApplicationContext();
        ImmutableMap authenticationTokensCache = securityApplicationContext.getConfigurationByAuthenticationToken();
        for (String authenticationToken : authenticationTokensCache.keySet()) {
            securityApplicationContext.invalidateAuthenticationToken(authenticationToken);
        }
        this.getApplicationContext().reloadConfiguration();
        return this.home();
    }
}

