/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.application.web;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import fr.ird.observe.application.web.ObserveWebApplicationContext;
import fr.ird.observe.application.web.request.ObserveWebRequestContext;
import fr.ird.observe.services.configuration.rest.ObserveDataSourceConfigurationRestConstants;
import fr.ird.observe.services.dto.ObserveSpeciesListConfiguration;
import fr.ird.observe.services.dto.constants.ReferentialLocale;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.debux.webmotion.server.WebMotionFilter;
import org.debux.webmotion.server.call.HttpContext;
import org.nuiton.converter.ConverterUtil;

public class ObserveWebMotionFilter
extends WebMotionFilter
implements ObserveDataSourceConfigurationRestConstants {
    public void inject(HttpContext context) {
        String authenticationToken;
        ObserveWebApplicationContext applicationContext = ObserveWebApplicationContext.getApplicationContext((HttpContext)context);
        HttpServletRequest request = context.getRequest();
        Locale applicationLocale = this.getApplicationLocale(request);
        ReferentialLocale referentialLocale = this.getReferentialLocale(request);
        ObserveSpeciesListConfiguration speciesListConfiguration = this.getSpeciesListConfiguration(applicationContext.getGsonSupplier().get(), request);
        String adminApiKey = this.getRequestHeaderOrParameterValueOrNull(request, "adminApiKey");
        if (Strings.isNullOrEmpty((String)adminApiKey)) {
            adminApiKey = null;
        }
        if (Strings.isNullOrEmpty((String)(authenticationToken = this.getRequestHeaderOrParameterValueOrNull(request, "authenticationToken")))) {
            authenticationToken = null;
        }
        ObserveWebRequestContext requestContext = new ObserveWebRequestContext(applicationContext, applicationLocale, referentialLocale, speciesListConfiguration, adminApiKey, authenticationToken);
        ObserveWebRequestContext.setRequestContext((HttpContext)context, (ObserveWebRequestContext)requestContext);
        this.doProcess();
    }

    protected ReferentialLocale getReferentialLocale(HttpServletRequest request) {
        ReferentialLocale referentialLocale = null;
        String referentialLocaleStr = this.getRequestHeaderOrParameterValueOrNull(request, "referentialLocale");
        if (referentialLocaleStr != null) {
            Locale referentialLoca = (Locale)ConverterUtil.convert(Locale.class, (Object)referentialLocaleStr);
            referentialLocale = ReferentialLocale.valueOf((Locale)referentialLoca);
        }
        return referentialLocale;
    }

    protected ObserveSpeciesListConfiguration getSpeciesListConfiguration(Gson gson, HttpServletRequest request) {
        ObserveSpeciesListConfiguration speciesListConfiguration = null;
        String speciesListConfigurationStr = this.getRequestHeaderOrParameterValueOrNull(request, "speciesListConfiguration");
        if (speciesListConfigurationStr != null) {
            speciesListConfiguration = (ObserveSpeciesListConfiguration)gson.fromJson(speciesListConfigurationStr, ObserveSpeciesListConfiguration.class);
        }
        return speciesListConfiguration;
    }

    protected Locale getApplicationLocale(HttpServletRequest request) {
        Locale applicationLocale = null;
        String applicationLocaleStr = this.getRequestHeaderOrParameterValueOrNull(request, "applicationLocale");
        if (applicationLocaleStr != null) {
            applicationLocale = (Locale)ConverterUtil.convert(Locale.class, (Object)applicationLocaleStr);
        }
        return applicationLocale;
    }

    protected String getRequestHeaderOrParameterValueOrNull(HttpServletRequest request, String parameterName) {
        String result = request.getHeader(parameterName);
        if (StringUtils.isBlank((CharSequence)result)) {
            result = this.getRequestParameterValueOrNull(request, parameterName);
        }
        return result;
    }

    protected String getRequestParameterValueOrNull(HttpServletRequest request, String parameterName) {
        String parameterValue = request.getParameter(parameterName);
        if (StringUtils.isBlank((CharSequence)parameterValue)) {
            parameterValue = null;
        }
        return parameterValue;
    }
}

