/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.components;

import fr.ifremer.wao.bean.ContactFilter;
import fr.ifremer.wao.bean.ContactFilterValues;
import fr.ifremer.wao.bean.ContactState;
import fr.ifremer.wao.bean.ObsProgram;
import fr.ifremer.wao.bean.SamplingFilter;
import fr.ifremer.wao.service.ServiceContact;
import fr.ifremer.wao.ui.components.FilterComponent;
import java.util.List;
import org.apache.tapestry5.SelectModel;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.util.EnumSelectModel;

public class ContactFilterComponent
extends FilterComponent<ContactFilter> {
    @Inject
    private Messages messages;
    @Parameter(required=true)
    private ServiceContact serviceContact;
    @Persist
    private ContactFilterValues possibleValuesForFilter;

    public void resetFilter() {
        this.setFilter((SamplingFilter)this.serviceContact.newContactFilter(this.getUser()));
    }

    protected boolean isAvailableDataForFiltersOnly() {
        return false;
    }

    public void updateSearchFields() {
        this.updatePossibleValuesForFilter();
    }

    public ContactFilterValues getPossibleValuesForFilter() {
        return this.getPossibleValuesForFilter(false);
    }

    public ContactFilterValues updatePossibleValuesForFilter() {
        return this.getPossibleValuesForFilter(true);
    }

    protected ContactFilterValues getPossibleValuesForFilter(boolean update) {
        if (update || this.possibleValuesForFilter == null) {
            this.possibleValuesForFilter = this.serviceContact.getPossibleValuesForFilter((ContactFilter)this.getFilter());
        }
        return this.possibleValuesForFilter;
    }

    public SelectModel getContactStateSelectModel() {
        return this.getContactStateSelectModel(this.messages);
    }

    public SelectModel getContactStateSelectModel(Messages messages) {
        List allowedStates = ContactState.getAllowedStates((ObsProgram)this.getUser().getProfile().getObsProgram());
        return new EnumSelectModel(ContactState.class, messages, (Enum[])allowedStates.toArray(new ContactState[allowedStates.size()]));
    }

    public Boolean getFiltersVisible() {
        Boolean filtersVisible = super.getFiltersVisible();
        if (filtersVisible == null && !(filtersVisible = this.getVisibleOnStartup()).booleanValue()) {
            filtersVisible = !((ContactFilter)this.getFilter()).isFiltered();
        }
        return filtersVisible;
    }

    public boolean showTerrestrialLocations() {
        boolean show = ((ContactFilter)this.getFilter()).getObservationUnit() != null || ((ContactFilter)this.getFilter()).getTerrestrialDistrict() != null;
        return show;
    }
}

