/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.services;

import fr.ifremer.wao.WaoBusinessException;
import fr.ifremer.wao.WaoContext;
import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.WaoProperty;
import fr.ifremer.wao.bean.ContactState;
import fr.ifremer.wao.bean.SamplingFilter;
import fr.ifremer.wao.entity.Boat;
import fr.ifremer.wao.entity.Contact;
import fr.ifremer.wao.entity.FishingZone;
import fr.ifremer.wao.entity.Profession;
import fr.ifremer.wao.entity.SampleRow;
import fr.ifremer.wao.service.ServiceUser;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.services.RegistryShutdownListener;
import org.apache.tapestry5.services.PersistentLocale;
import org.nuiton.util.ApplicationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaoManager
implements Runnable,
RegistryShutdownListener {
    private static final Logger log = LoggerFactory.getLogger(WaoManager.class);
    private WaoContext context;
    private ServiceUser serviceUser;
    private PersistentLocale localeService;

    public WaoManager(WaoContext context) {
        this.context = context;
    }

    void setServiceUser(ServiceUser serviceUser) {
        this.serviceUser = serviceUser;
    }

    public void setLocaleService(PersistentLocale localeService) {
        this.localeService = localeService;
    }

    @Override
    public void run() {
        this.context.start(this.serviceUser);
    }

    public void registryDidShutdown() {
        this.context.stop();
    }

    WaoContext getContext() {
        return this.context;
    }

    public boolean isActivityCalendarImportRun() {
        return this.context.isActivityCalendarImportRun();
    }

    public String getProperty(WaoProperty property) {
        return this.context.getProperty(property);
    }

    public ApplicationConfig getConfiguration() {
        return this.context.getConfiguration();
    }

    public Date getCurrentDate() {
        return this.context.getCurrentDate();
    }

    public boolean isDevEnvironment() {
        return log.isDebugEnabled();
    }

    public String[] getErrorMessages(WaoException eee, Messages messages, Logger logger) {
        String[] results = null;
        String cause = null;
        if (eee.getCause() != null && this.isDevEnvironment()) {
            cause = eee.getCause().getClass().getSimpleName() + " : " + eee.getCause().getMessage();
            results = new String[2];
            results[1] = cause;
        } else {
            results = new String[1];
        }
        if (logger.isDebugEnabled()) {
            logger.debug("ERROR from business : " + eee.getMessage() + " _ args = " + eee.getArgs());
            if (cause != null) {
                logger.debug("ERROR caused by : " + cause);
            }
        }
        results[0] = eee.getArgs() != null ? messages.format(eee.getMessage(), eee.getArgs()) : messages.get(eee.getMessage());
        return results;
    }

    public String getErrorMessage(WaoBusinessException eee, Messages messages, Logger logger) {
        if (logger.isDebugEnabled()) {
            logger.debug("ERROR from business : " + eee.getMessage());
        }
        return eee.getMessage();
    }

    public String getTooltipText(String input) {
        if (input != null) {
            return input.replaceAll("\n", "<br />").replaceAll("\r", "");
        }
        return "";
    }

    public String getTooltipSampleRow(SampleRow row) {
        StringBuilder result = new StringBuilder();
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/yyyy");
        Profession profession = row.getProfession();
        result.append("<strong>M\u00e9tier : </strong>").append(row.getProfessionDescription());
        result.append(" - ").append(profession.getLibelle());
        if (!StringUtils.isEmpty((String)profession.getSpecies())) {
            result.append("\n<strong>Esp\u00e8ces cibles : </strong>").append(profession.getSpecies());
        }
        result.append("\n<strong>Programme : </strong>").append(row.getProgramName()).append("\n<strong>P\u00e9riode : </strong> du ").append(dateFormat.format(row.getPeriodBegin())).append(" au ").append(dateFormat.format(row.getPeriodEnd()));
        for (FishingZone zone : row.getFishingZone()) {
            result.append("\n<strong>Zone de p\u00eache : </strong>").append(zone.getCode());
        }
        return this.getTooltipText(result.toString());
    }

    public String getTooltipBoat(Boat boat) {
        StringBuilder result = new StringBuilder("<strong>").append(boat.getImmatriculation()).append("</strong>").append("\n<strong>Quartier : </strong>").append(boat.getDistrictCode()).append("\n<strong>Longueur : </strong>").append(boat.getBoatLength()).append(" m").append("\n<strong>Ann\u00e9e de construction : </strong>").append(boat.getBuildYear());
        return this.getTooltipText(result.toString());
    }

    public String getDataSamplingTitle(SamplingFilter filter) {
        StringBuilder result = new StringBuilder("Donn\u00e9es des mar\u00e9es");
        String separator = " : ";
        if (filter.getCompany() != null) {
            result.append(separator).append("\nSoci\u00e9t\u00e9 ").append(filter.getCompany().getName());
            separator = ", ";
        }
        if (StringUtils.isNotEmpty((String)filter.getProgramName())) {
            result.append(separator).append("\nProgramme ").append(filter.getProgramName());
            separator = ", ";
        }
        if (filter.getSampleRow() != null) {
            Profession profession = filter.getSampleRow().getProfession();
            result.append(separator).append("\nM\u00e9tier ").append(filter.getSampleRow().getCode());
            if (StringUtils.isNotEmpty((String)profession.getLibelle())) {
                result.append(" - ").append(profession.getLibelle());
            }
            if (StringUtils.isNotEmpty((String)profession.getSpecies())) {
                result.append("\nEsp\u00e8ces (").append(profession.getSpecies()).append(")");
            }
            result.append("\nZones de p\u00eache (");
            for (FishingZone zone : filter.getSampleRow().getFishingZone()) {
                result.append(zone.getDistrictCode()).append(' ');
            }
            result.append(")");
            separator = ", ";
        } else {
            if (filter.getFacadeName() != null) {
                result.append(separator).append("\nFa\u00e7ade ").append(filter.getFacadeName());
                separator = ", ";
            }
            if (filter.getSectorName() != null) {
                result.append(separator).append("\nZone ").append(filter.getSectorName());
            }
        }
        return result.toString();
    }

    public String getContactStyle(Contact contact, boolean admin) {
        String result = "";
        boolean accepted = BooleanUtils.isTrue((Boolean)contact.getValidationProgram()) || !admin && BooleanUtils.isTrue((Boolean)contact.getValidationCompany());
        ContactState state = contact.getContactState();
        result = BooleanUtils.isFalse((Boolean)contact.getValidationProgram()) || !admin && BooleanUtils.isFalse((Boolean)contact.getValidationCompany()) ? "refused" : (accepted && state.equals((Object)ContactState.OBSERVATION_DONE) ? "accepted" : (accepted && state.isUnfinishedState() ? "unfinished" : (state.isFinalState() ? "even" : "odd")));
        return result;
    }

    public void changeLocale() {
        Locale currentLocale = this.localeService.get();
        Locale newLocale = Locale.ENGLISH.equals(currentLocale) ? Locale.FRENCH : Locale.ENGLISH;
        this.localeService.set(newLocale);
        this.context.setLocale(newLocale);
    }
}

