/*
 * #%L
 * Wao :: Web Interface
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.bean.WaoFilter;
import fr.ifremer.wao.service.ServiceCartography;
import fr.ifremer.wao.service.ServiceUser;
import fr.ifremer.wao.ui.data.RequiresAuthentication;
import fr.ifremer.wao.ui.data.TapestryUtil;
import fr.ifremer.wao.ui.services.KmlLoaderStrategy;
import fr.ifremer.wao.ui.services.KmlLoaderStrategyContacts;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.ioc.annotations.Inject;

import java.io.IOException;

/**
 * Page used directly as url for OpenLayers Kml reference. The activate method
 * will return the StreamResponse with Kml data depends on {@link StrategyValues}
 * defined as first element in page context.
 *
 * Created: 6 juil. 2010
 *
 * @author fdesbois <fdesbois@codelutin.com>
 * @version $Id: KmlLoader.java 650 2010-10-03 15:14:48Z fdesbois $
 */
@RequiresAuthentication
public class KmlLoader {

    /** Strategy values for loading Kml */
    public enum StrategyValues {
        CONTACTS;
    }

    @SessionState(create = false)
    private WaoFilter cartographyFilter;

    @Inject
    private ServiceCartography serviceCartography;

    @Inject
    private ServiceUser serviceUser;

    /**
     * This method will directly return the correct Kml file depends on strategy
     * from {@code activationContext}. Other elements used by strategies can
     * be passed to the context (like filter values). Available strategies are
     * defined in {@link StrategyValues} enumeration.
     *
     * @param activationContext Context of the page.
     * @return the StreamResponse that contains Kml data.
     * @throws IOException from stream error
     * @see KmlLoaderStrategy#getStreamResponse(WaoFilter)
     */
    StreamResponse onActivate(Object... activationContext) throws IOException {
        // Retrive context data
        String first = TapestryUtil.getFirstString(activationContext);
        Object[] other = TapestryUtil.getOtherContext(activationContext);

        // Create strategy depends on first value in page context.
        KmlLoaderStrategy strategy = createStrategy(StrategyValues.valueOf(first));

        // Return the StreamResponse from the Strategy
        return strategy.getStreamResponse(cartographyFilter);
    }

    /**
     * Instantiate the strategy depends on {@code value}.
     *
     * @param value StrategyValues to define wich implementation to choose.
     * @return the KmlLoaderStrategy to use
     * @throws IllegalArgumentException  if the strategy is not supported
     */
    KmlLoaderStrategy createStrategy(StrategyValues value) throws IllegalArgumentException {
        switch (value) {
            case CONTACTS:
                return new KmlLoaderStrategyContacts(serviceCartography, serviceUser);
        }
        throw new IllegalArgumentException(value + " is not supported as KmlLoaderStrategy");
    }
}
