/*
 * #%L
 * Wao :: Web Interface
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.wao.ui.components;

import fr.ifremer.wao.entity.Indicator;
import fr.ifremer.wao.entity.IndicatorLevel;
import fr.ifremer.wao.service.ServiceSynthesis;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.slf4j.Logger;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * Render a table with levels as columns and two lines : level number and
 * lower + upper bound values. The table has a header with indicator name
 * and coefficient
 *
 * @author bleny
 */
public class IndicatorLevels {

    @Inject
    private Logger log;

    @Parameter(required = true)
    private Indicator indicator;

    @Parameter(required = false)
    private IndicatorLevel highlightLevel;

    /** if true, add a last line with a text explaining what colors mean. */
    @Parameter(required = false)
    private Boolean withLegend;

    @Parameter
    private Boolean editable;

    /* variable used in view */
    @Property
    private IndicatorLevel indicatorLevel;

    /* variable used in view */
    private List<IndicatorLevel> indicatorLevels;

    public Indicator getIndicator() {
	    return indicator;
    }

    public Boolean isWithLegend() {
        if (withLegend == null) {
            withLegend = false;
        }
        return withLegend;
    }

    public void setWithLegend(Boolean withLegend) {
        this.withLegend = withLegend;
    }

    public void setEditable(Boolean editable) {
        this.editable = editable;
    }

    public Boolean getEditable() {
        if (editable == null) {
            editable = false;
        }
        return editable;
    }

    public boolean highLightCurrentIndicatorLevel() {
        if (log.isDebugEnabled()) {
            log.debug("indicatorLevel = " + indicatorLevel);
            log.debug("highlightLevel = " + highlightLevel);
        }
        return indicatorLevel.equals(highlightLevel);
    }

}
