/*
 * *##% 
 * Wao :: Web Interface
 * Copyright (C) 2009 - 2010 Ifremer
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */

package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.entity.News;
import fr.ifremer.wao.entity.NewsImpl;
import fr.ifremer.wao.entity.WaoUser;
import fr.ifremer.wao.service.ServiceNews;
import fr.ifremer.wao.ui.base.WaoPage;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.tapestry5.Asset2;
import org.apache.tapestry5.PersistenceConstants;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Path;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.slf4j.Logger;

/**
 * Index
 *
 * Created: 9 nov. 2009
 *
 * @author fdesbois
 * @version $Revision: 409 $
 *
 * Mise a jour: $Date: 2010-04-01 20:21:22 +0200 (jeu., 01 avril 2010) $
 * par : $Author: fdesbois $
 */
@IncludeStylesheet("context:css/news.css")
public class Index implements WaoPage {
    
    /**
     * No restriction to display this page.
     *
     * @return true
     */
    @Override
    public boolean canDisplay() {
        return true;
    }

    @Inject
    private ServiceNews serviceNews;

    @Inject
    private Logger log;

    @SessionState
    @Property
    private WaoUser user;

    @Persist
    private List<News> newsList;

    @Property
    private News news;

    private DateFormat dateFormat;

    @Persist(PersistenceConstants.FLASH)
    private String editedId;

    @Property
    private int rowIndex;

    @Property
    @Inject
    @Path("context:js/FCKConf.js")
    private Asset2 fckconf;


    @Log
    void setupRender() throws WaoException {
        if (editedId == null || !"NEW".equals(editedId)) {
            newsList = null;
            getNewsList();
        }
    }

//    void onActivate(EventContext ec) {
//        if (ec.getCount() > 0) {
//            this.editedId = ec.get(String.class, 0);
//        }
//    }
//
//    String onPassivate() {
//        return editedId;
//    }

    public List<News> getNewsList() throws WaoException {
        if (newsList == null) {
            newsList = serviceNews.getNews();
        }
        return newsList;
    }

    public boolean canEditNews() {
        return user.isAdmin() && !user.getReadOnly();
    }

    public boolean isEditionMode() {
        return isCreateMode() || news.getTopiaId().equals(editedId);
    }

    public boolean isCreateMode() {
        return news.getTopiaId() == null;
    }

    public DateFormat getDateFormat() {
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        }
        return dateFormat;
    }

    void onActionFromAddNews() throws WaoException {
        news = new NewsImpl();
        // Create a new list with the new news in first position
        List<News> list = new ArrayList<News>();
        list.add(news);
        list.addAll(getNewsList());
        newsList = list;
        editedId = "NEW";
    }

    void onActionFromEditNews(int rowIndex) throws WaoException {
        news = getNewsList().get(rowIndex);
        this.editedId = news.getTopiaId();
    }

    void onActionFromDeleteNews(int rowIndex) throws WaoException {
        news = getNewsList().get(rowIndex);
        serviceNews.saveNews(news, true);
        //newsList = null;
    }

    void onActionFromCancelEdit() {
    }

    void onSelectedFromSaveNews(int rowIndex) throws WaoException {
        news = getNewsList().get(rowIndex);
    }

    void onSuccessFromNewsForm() throws WaoException {
        if (canEditNews()) {
            serviceNews.saveNews(news, false);
            //this.editedId = null;
            if (log.isDebugEnabled()) {
                log.debug(news.getContent());
            }
        }
    }
        
}
