/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.action;

import fr.ifremer.adagio.core.AdagioTechnicalException;
import fr.ifremer.adagio.core.action.ActionUtils;
import fr.ifremer.adagio.core.config.AdagioConfiguration;
import fr.ifremer.adagio.core.dao.technical.DaoUtils;
import fr.ifremer.adagio.core.service.DatabaseSchemaService;
import fr.ifremer.adagio.core.service.ServiceLocator;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.version.Version;

public class DatabaseStatusAction {
    private static final Log log = LogFactory.getLog(DatabaseStatusAction.class);

    public void run() {
        AdagioConfiguration config = AdagioConfiguration.getInstance();
        if (log.isInfoEnabled()) {
            log.info((Object)"Starting database status report...");
        }
        ActionUtils.logConnectionProperties();
        boolean isValidConnection = DaoUtils.isValidConnectionProperties(config.getJdbcDriver(), config.getJdbcURL(), config.getJdbcUsername(), config.getJdbcPassword());
        if (!isValidConnection) {
            log.warn((Object)"Connection error : could not check database status.");
            return;
        }
        DatabaseSchemaService databaseSchemaService = ServiceLocator.instance().getService("databaseSchemaService", DatabaseSchemaService.class);
        if (!databaseSchemaService.isDbLoaded()) {
            log.warn((Object)"Database not start ! Could not check database status.");
            return;
        }
        try {
            Version actualDbVersion = databaseSchemaService.getDbVersion();
            if (actualDbVersion != null) {
                log.info((Object)("Database schema version is: " + actualDbVersion.toString()));
            }
            Version expectedDbVersion = databaseSchemaService.getApplicationVersion();
            log.info((Object)("Database schema version AFTER an update should be: " + expectedDbVersion.toString()));
        }
        catch (AdagioTechnicalException e) {
            log.error((Object)"Error while getting versions.", (Throwable)e);
        }
        File outputFile = ActionUtils.checkAndGetOutputFile(false, this.getClass());
        try {
            log.info((Object)"Launching status report generation...");
            databaseSchemaService.generateStatusReport(outputFile);
            if (outputFile != null) {
                log.info((Object)String.format("Database status report successfullly generated at %s", outputFile));
            } else {
                log.info((Object)"Database status report successfullly generated.");
            }
        }
        catch (AdagioTechnicalException e) {
            log.error((Object)"Error while writing database status report.", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"Error while writing database status report.", (Throwable)e);
        }
    }
}

