/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.action;

import fr.ifremer.adagio.core.AdagioTechnicalException;
import fr.ifremer.adagio.core.action.ActionUtils;
import fr.ifremer.adagio.core.config.AdagioConfiguration;
import fr.ifremer.adagio.core.dao.technical.DaoUtils;
import fr.ifremer.adagio.core.service.DatabaseSchemaService;
import fr.ifremer.adagio.core.service.ServiceLocator;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.version.Version;

public class DatabaseDiffAction {
    private static final Log log = LogFactory.getLog(DatabaseDiffAction.class);

    public void run() {
        AdagioConfiguration config = AdagioConfiguration.getInstance();
        if (log.isInfoEnabled()) {
            log.info((Object)"Starting database schema diff (compare to model)...");
        }
        ActionUtils.logConnectionProperties();
        boolean isValidConnection = DaoUtils.isValidConnectionProperties(config.getJdbcDriver(), config.getJdbcURL(), config.getJdbcUsername(), config.getJdbcPassword());
        if (!isValidConnection) {
            log.warn((Object)"Connection error: could not report schema diff.");
            return;
        }
        DatabaseSchemaService databaseSchemaService = ServiceLocator.instance().getService("databaseSchemaService", DatabaseSchemaService.class);
        if (!databaseSchemaService.isDbLoaded()) {
            log.warn((Object)"Database not start ! Could not report schema diff.");
            return;
        }
        try {
            Version actualDbVersion = databaseSchemaService.getDbVersion();
            if (actualDbVersion != null) {
                log.info((Object)("Database schema version is: " + actualDbVersion.toString()));
            }
            Version modelVersion = config.getVersion();
            log.info((Object)("Model version is: " + modelVersion.toString()));
        }
        catch (AdagioTechnicalException e) {
            log.error((Object)"Error while getting versions.", (Throwable)e);
        }
        File outputFile = ActionUtils.checkAndGetOutputFile(false, this.getClass());
        try {
            log.info((Object)"Launching diff report generation...");
            databaseSchemaService.generateDiffReport(outputFile);
            if (outputFile != null) {
                log.info((Object)String.format("Database diff successfullly generated at %s", outputFile));
            } else {
                log.info((Object)"Database diff successfullly generated.");
            }
        }
        catch (AdagioTechnicalException e) {
            log.error((Object)"Error while generating status report file.", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"Error while generating status report file.", (Throwable)e);
        }
    }
}

