/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.converter;

import java.util.EnumSet;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.converter.NuitonConverter;

public class EnumConverter<E extends Enum>
implements NuitonConverter<E> {
    private static final Log LOGGER = LogFactory.getLog(EnumConverter.class);
    protected Object defaultValue;
    protected boolean useDefault;
    protected Class<E> enumType;

    public <T> T convert(Class<T> aClass, Object value) {
        if (value == null) {
            if (this.useDefault) {
                return aClass.cast(this.defaultValue);
            }
            throw new ConversionException(String.format("No value specified for converter %s", this));
        }
        if (EnumConverter.isEnabled(aClass, this.enumType)) {
            if (EnumConverter.isEnabled(value.getClass(), this.enumType)) {
                Object result = value;
                return aClass.cast(result);
            }
            if (value instanceof String) {
                Object result;
                try {
                    result = this.valueOf(aClass, value);
                }
                catch (IllegalArgumentException e) {
                    result = this.convertFromOrdinal(aClass, value);
                }
                return aClass.cast(result);
            }
            if (value instanceof Integer) {
                Object result = this.convertFromOrdinal(aClass, value);
                return aClass.cast(result);
            }
        }
        throw new ConversionException(String.format("no convertor found for type %2$s and objet '%1$s'", aClass.getName(), value));
    }

    public EnumConverter(Class<E> enumType, Object defaultValue) {
        this.enumType = enumType;
        this.defaultValue = defaultValue;
        boolean bl = this.useDefault = defaultValue != null;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(this.toString() + '<' + enumType + '>'));
        }
    }

    public EnumConverter(Class<E> enumType) {
        this(enumType, null);
    }

    @Override
    public Class<E> getType() {
        return this.enumType;
    }

    protected static boolean isEnabled(Class<?> aClass, Class<?> enumType) {
        return aClass != null && aClass.isEnum() && aClass.equals(enumType);
    }

    protected Object convertFromOrdinal(Class<?> aClass, Object value) {
        Enum result;
        block3: {
            result = null;
            try {
                int ordinal = Integer.valueOf(value + "");
                EnumSet<?> vals = this.allOf(aClass);
                if (ordinal <= -1 || ordinal >= vals.size()) break block3;
                for (Enum val : vals) {
                    if (val.ordinal() != ordinal) continue;
                    result = val;
                    break;
                }
            }
            catch (NumberFormatException e1) {
                result = null;
            }
        }
        return result;
    }

    protected Object valueOf(Class<?> aClass, Object value) {
        Object result = Enum.valueOf(aClass, (String)value);
        return result;
    }

    protected EnumSet<?> allOf(Class<?> aClass) {
        EnumSet<?> vals = EnumSet.allOf(aClass);
        return vals;
    }
}

