/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec.result.filter;

import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.spec.ExpressionArguments;
import org.eclipse.datatools.connectivity.oda.spec.ExpressionVariable;
import org.eclipse.datatools.connectivity.oda.spec.ValidationContext;
import org.eclipse.datatools.connectivity.oda.spec.result.FilterExpression;
import org.eclipse.datatools.connectivity.oda.spec.util.ValidatorUtil;

public abstract class AtomicExpression
extends FilterExpression {
    private ExpressionVariable m_variable;
    private ExpressionArguments m_args;

    protected AtomicExpression(ExpressionVariable variable, ExpressionArguments args) {
        this.setVariable(variable);
        this.setArguments(args);
    }

    public ExpressionVariable getVariable() {
        return this.m_variable;
    }

    public void setVariable(ExpressionVariable variable) {
        this.m_variable = variable;
    }

    public ExpressionArguments getArguments() {
        if (this.m_args == null) {
            this.m_args = new ExpressionArguments(null);
        }
        return this.m_args;
    }

    public void setArguments(ExpressionArguments args) {
        this.m_args = args;
    }

    public boolean isOptionable() {
        return false;
    }

    @Override
    public void validate(ValidationContext context) throws OdaException {
        try {
            super.validate(context);
        }
        catch (OdaException ex) {
            throw ValidatorUtil.newFilterExprException(this, ex);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(String.valueOf(this.getName()) + " -> \n\t");
        buffer.append(this.m_variable);
        buffer.append(";\n\t");
        buffer.append(this.m_args);
        return buffer.toString();
    }
}

