/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service.synchro;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.TuttiTechnicalException;
import fr.ifremer.tutti.persistence.service.synchro.ReferentialSynchronizeHelper;
import fr.ifremer.tutti.persistence.service.synchro.TuttiAssociationTableMetadata;
import fr.ifremer.tutti.persistence.service.synchro.TuttiEntityTableMetadata;
import fr.ifremer.tutti.persistence.service.synchro.TuttiTable;
import fr.ifremer.tutti.persistence.service.synchro.TuttiTableMetadata;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.mapping.Table;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.hibernate.tool.hbm2ddl.TableMetadata;
import org.nuiton.i18n.I18n;

public class TuttiDatabaseMetadata {
    protected final DatabaseMetadata delegate;
    protected Map<String, TuttiTableMetadata> tables;
    protected DatabaseMetaData meta;

    public TuttiDatabaseMetadata(Connection connection, Dialect dialect) {
        Preconditions.checkNotNull((Object)connection);
        Preconditions.checkNotNull((Object)dialect);
        try {
            this.delegate = new DatabaseMetadata(connection, dialect, true);
            this.meta = connection.getMetaData();
        }
        catch (SQLException e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.persistence.dbMetadata.instanciation.error", (Object[])new Object[]{connection}), e);
        }
        this.tables = Maps.newTreeMap();
    }

    public TuttiTableMetadata getTable(String name) throws HibernateException {
        return this.getTable(name, "PUBLIC", null, false);
    }

    public TuttiEntityTableMetadata getEntityTable(String name) throws HibernateException {
        TuttiTableMetadata table = this.getTable(name);
        Preconditions.checkState((boolean)ReferentialSynchronizeHelper.IS_ENTITY_TABLE.apply((Object)table));
        return (TuttiEntityTableMetadata)table;
    }

    public TuttiAssociationTableMetadata getAssociationTable(String name) throws HibernateException {
        TuttiTableMetadata table = this.getTable(name);
        Preconditions.checkState((boolean)ReferentialSynchronizeHelper.IS_ASSOCIATION_TABLE.apply((Object)table));
        return (TuttiAssociationTableMetadata)table;
    }

    public int getTableCount() {
        return this.tables.size();
    }

    public Set<String> getTableNames() {
        HashSet result = Sets.newHashSet();
        for (TuttiTableMetadata tableMetadata : this.tables.values()) {
            result.add(tableMetadata.getName());
        }
        return result;
    }

    protected TuttiTableMetadata getTable(String name, String schema, String catalog, boolean isQuoted) throws HibernateException {
        String key = Table.qualify((String)catalog, (String)schema, (String)name);
        TuttiTableMetadata tuttiTableMetadata = this.tables.get(key);
        if (tuttiTableMetadata == null) {
            TableMetadata tableMetadata = this.delegate.getTableMetadata(name, schema, catalog, isQuoted);
            Preconditions.checkNotNull((Object)tableMetadata, (Object)("Could not find db table " + name));
            TuttiTable tuttiTable = TuttiTable.valueOf(name);
            Preconditions.checkNotNull((Object)((Object)tuttiTable), (Object)("Could not find db table " + (Object)((Object)tuttiTable)));
            tuttiTableMetadata = tuttiTable.isAssociation() ? new TuttiAssociationTableMetadata(tableMetadata, this.meta) : new TuttiEntityTableMetadata(tableMetadata, this.meta);
            Preconditions.checkNotNull((Object)tuttiTableMetadata, (Object)("Could not find db table " + name));
            this.tables.put(key, tuttiTableMetadata);
        }
        return tuttiTableMetadata;
    }
}

