/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.common;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.andromda.core.common.ClassUtils;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.common.PathMatcher;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ResourceUtils {
    private static final Logger logger = Logger.getLogger((Class)(class$org$andromda$core$common$ResourceUtils == null ? (class$org$andromda$core$common$ResourceUtils = ResourceUtils.class$("org.andromda.core.common.ResourceUtils")) : class$org$andromda$core$common$ResourceUtils));
    private static final String ARCHIVE_PREFIX = "jar:";
    private static final String FILE_PREFIX = "file:";
    private static final String CLASSPATH_PREFIX = "classpath:";
    private static final char LINE_SEPARATOR = '\n';
    private static final String PATH_WHITESPACE_CHARACTER = "%20";
    private static final String URL_DECODE_ENCODING = "UTF-8";
    private static final String FORWARD_SLASH = "/";
    private static final String BACK_SLASH_NORMALIZATION_PATTERN = "\\\\+";
    private static final String FORWARD_SLASH_NORMALIZATION_PATTERN = "/+";
    static /* synthetic */ Class class$org$andromda$core$common$ResourceUtils;

    public static URL getResource(String resourceName) {
        ExceptionUtils.checkEmpty("resourceName", resourceName);
        ClassLoader loader = ClassUtils.getClassLoader();
        return loader != null ? loader.getResource(resourceName) : null;
    }

    public static String getContents(URL resource) {
        try {
            return ResourceUtils.getContents(resource != null ? new InputStreamReader(resource.openStream()) : null);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static String getContents(Reader resource) {
        StringBuffer contents = new StringBuffer();
        try {
            if (resource != null) {
                BufferedReader resourceInput = new BufferedReader(resource);
                String line = resourceInput.readLine();
                while (line != null) {
                    contents.append(line).append('\n');
                    line = resourceInput.readLine();
                }
                resourceInput.close();
                resourceInput = null;
            }
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        return contents.toString().trim();
    }

    public static List getClassPathArchiveContents(URL resource) {
        ZipFile archive;
        ArrayList<String> contents = new ArrayList<String>();
        if (ResourceUtils.isArchive(resource) && (archive = ResourceUtils.getArchive(resource)) != null) {
            Enumeration<? extends ZipEntry> entries = archive.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                contents.add(entry.getName());
            }
        }
        return contents;
    }

    public static List getDirectoryContents(URL resource, int levels) {
        return ResourceUtils.getDirectoryContents(resource, levels, true);
    }

    public static String unescapeFilePath(String filePath) {
        if (filePath != null && filePath.length() > 0) {
            filePath = filePath.replaceAll(PATH_WHITESPACE_CHARACTER, " ");
        }
        return filePath;
    }

    public static List getDirectoryContents(URL resource, int levels, boolean includeSubdirectories) {
        File fileResource;
        ArrayList contents = new ArrayList();
        if (resource != null && (fileResource = new File(ResourceUtils.unescapeFilePath(resource.getFile()))).isDirectory()) {
            File rootDirectory = fileResource;
            for (int ctr = 0; ctr < levels; ++ctr) {
                rootDirectory = rootDirectory.getParentFile();
            }
            File pluginDirectory = rootDirectory;
            ResourceUtils.loadFiles(pluginDirectory, contents, includeSubdirectories);
            ListIterator<String> iterator = contents.listIterator();
            while (iterator.hasNext()) {
                iterator.set(StringUtils.replace((String)((File)iterator.next()).getPath().replace('\\', '/'), (String)(pluginDirectory.getPath().replace('\\', '/') + '/'), (String)""));
            }
        }
        return contents;
    }

    private static void loadFiles(File directory, List fileList, boolean includeSubdirectories) {
        File[] files;
        if (directory != null && (files = directory.listFiles()) != null) {
            for (int ctr = 0; ctr < files.length; ++ctr) {
                File file = files[ctr];
                if (!file.isDirectory()) {
                    fileList.add(file);
                    continue;
                }
                if (!includeSubdirectories) continue;
                ResourceUtils.loadFiles(file, fileList, includeSubdirectories);
            }
        }
    }

    public static boolean isArchive(URL resource) {
        return resource != null && resource.toString().startsWith(ARCHIVE_PREFIX);
    }

    public static ZipFile getArchive(URL resource) {
        try {
            ZipFile archive = null;
            if (resource != null) {
                String resourceUrl = resource.toString();
                int entryPrefixIndex = (resourceUrl = resourceUrl.replaceFirst(ARCHIVE_PREFIX, "")).indexOf(33);
                if (entryPrefixIndex != -1) {
                    resourceUrl = resourceUrl.substring(0, entryPrefixIndex);
                }
                resourceUrl = URLDecoder.decode(new URL(resourceUrl).getFile(), URL_DECODE_ENCODING);
                archive = new ZipFile(resourceUrl);
            }
            return archive;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static String getContents(String resourceName) {
        return ResourceUtils.getContents(ResourceUtils.getResource(resourceName));
    }

    public static URL getClassResource(String className) {
        ExceptionUtils.checkEmpty("className", className);
        return ResourceUtils.getResource(ResourceUtils.getClassNameAsResource(className));
    }

    private static String getClassNameAsResource(String className) {
        return className.replace('.', '/') + ".class";
    }

    public static URL getResource(String resourceName, String directory) {
        File file;
        ExceptionUtils.checkEmpty("resourceName", resourceName);
        if (directory != null && (file = new File(directory, resourceName)).exists()) {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return ResourceUtils.getResource(resourceName);
    }

    public static void makeDirectories(String location) {
        File file = new File(location);
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
    }

    public static long getLastModifiedTime(URL resource) {
        long lastModified;
        try {
            File file = new File(resource.getFile());
            if (file.exists()) {
                lastModified = file.lastModified();
            } else {
                URLConnection uriConnection = resource.openConnection();
                lastModified = uriConnection.getLastModified();
                uriConnection = null;
                System.gc();
            }
        }
        catch (Exception exception) {
            lastModified = 0L;
        }
        return lastModified;
    }

    public static URL getResource(String resourceName, URL directory) {
        String directoryLocation = null;
        if (directory != null) {
            directoryLocation = directory.getFile();
        }
        return ResourceUtils.getResource(resourceName, directoryLocation);
    }

    public static URL toURL(String path) {
        URL url = null;
        if (path != null) {
            path = ResourceUtils.normalizePath(path);
            try {
                File file;
                url = path.startsWith(CLASSPATH_PREFIX) ? ResourceUtils.resolveClasspathResource(path) : ((file = new File(path)).exists() ? file.toURI().toURL() : new URL(path));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return url;
    }

    public static URL resolveClasspathResource(String path) {
        URL urlResource = null;
        if (path.startsWith(CLASSPATH_PREFIX)) {
            int nestedPathOffset = (path = path.substring(CLASSPATH_PREFIX.length(), path.length())).indexOf("!/");
            String resourcePath = nestedPathOffset == -1 ? path : path.substring(0, nestedPathOffset);
            String nestingPath = nestedPathOffset == -1 ? "" : path.substring(nestedPathOffset);
            urlResource = Thread.currentThread().getContextClassLoader().getResource(resourcePath);
            if (urlResource == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Resource could not be located on the classpath: " + resourcePath));
                }
            } else {
                try {
                    String resourceFileName;
                    int fileNameOffset = resourcePath.lastIndexOf(47);
                    String string = resourceFileName = fileNameOffset == -1 ? resourcePath : resourcePath.substring(fileNameOffset + 1);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Creating temporary copy on the file system of the classpath resource");
                    }
                    File fileSystemResource = File.createTempFile(resourceFileName, null);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Temporary file will be deleted on VM exit: " + fileSystemResource.getAbsolutePath()));
                    }
                    fileSystemResource.deleteOnExit();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Copying classpath resource contents into temporary file");
                    }
                    ResourceUtils.writeUrlToFile(urlResource, fileSystemResource.toString(), null);
                    int nestingCount = StringUtils.countMatches((String)path, (String)"!/");
                    StringBuffer buffer = new StringBuffer();
                    for (int ctr = 0; ctr < nestingCount; ++ctr) {
                        buffer.append(ARCHIVE_PREFIX);
                    }
                    buffer.append(FILE_PREFIX).append(fileSystemResource.getAbsolutePath()).append(nestingPath);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Constructing URL to " + (nestingCount > 0 ? "nested" : "") + " resource in temporary file"));
                    }
                    urlResource = new URL(buffer.toString());
                }
                catch (IOException exception) {
                    logger.warn((Object)"Unable to resolve classpath resource", (Throwable)exception);
                    urlResource = null;
                }
            }
        }
        return urlResource;
    }

    public static void writeUrlToFile(URL url, String fileLocation, String encoding) throws IOException {
        ExceptionUtils.checkNull("url", url);
        ExceptionUtils.checkEmpty("fileLocation", fileLocation);
        File file = new File(fileLocation);
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));
        if (StringUtils.isNotBlank((String)encoding)) {
            BufferedReader inputReader = new BufferedReader(new InputStreamReader(url.openStream(), encoding));
            int ctr = inputReader.read();
            while (ctr != -1) {
                ((OutputStream)stream).write(ctr);
                ctr = inputReader.read();
            }
            inputReader.close();
            inputReader = null;
        } else {
            BufferedInputStream inputStream = new BufferedInputStream(url.openStream());
            int ctr = ((InputStream)inputStream).read();
            while (ctr != -1) {
                ((OutputStream)stream).write(ctr);
                ctr = ((InputStream)inputStream).read();
            }
            ((InputStream)inputStream).close();
            inputStream = null;
        }
        ((OutputStream)stream).flush();
        ((OutputStream)stream).close();
        stream = null;
    }

    public static boolean isFile(URL url) {
        return url != null && new File(url.getFile()).isFile();
    }

    public static void deleteDirectory(File directory) {
        File[] files;
        if (directory != null && directory.exists() && directory.isDirectory() && (files = directory.listFiles()) != null && files.length > 0) {
            int mergedTemplatesCount = files.length;
            for (int ctr = 0; ctr < mergedTemplatesCount; ++ctr) {
                File file = files[ctr];
                if (file.isDirectory()) {
                    ResourceUtils.deleteDirectory(file);
                    file.delete();
                    continue;
                }
                file.delete();
            }
        }
    }

    public static List getDirectoryContents(URL url, boolean absolute, String[] patterns) {
        List contents = ResourceUtils.getDirectoryContents(url, 0, true);
        if (!contents.isEmpty()) {
            ListIterator<String> iterator = contents.listIterator();
            while (iterator.hasNext()) {
                String path = (String)iterator.next();
                if (!ResourceUtils.matchesAtLeastOnePattern(path, patterns)) {
                    iterator.remove();
                    continue;
                }
                if (!absolute) continue;
                String string = path = url.toString().endsWith(FORWARD_SLASH) ? path : FORWARD_SLASH + path;
                URL resource = ResourceUtils.toURL(url + path);
                if (resource == null) continue;
                iterator.set(resource.toString());
            }
        } else {
            String urlAsString = url.toString();
            String delimiter = "!/";
            String archivePath = urlAsString.replaceAll("!/.*", "!/");
            contents = ResourceUtils.getClassPathArchiveContents(url);
            ListIterator<String> iterator = contents.listIterator();
            while (iterator.hasNext()) {
                String relativePath = (String)iterator.next();
                String fullPath = archivePath + relativePath;
                if (!fullPath.startsWith(urlAsString) || fullPath.equals(urlAsString + FORWARD_SLASH)) {
                    iterator.remove();
                    continue;
                }
                if (!ResourceUtils.matchesAtLeastOnePattern(relativePath, patterns)) {
                    iterator.remove();
                    continue;
                }
                if (!absolute) continue;
                iterator.set(fullPath);
            }
        }
        return contents;
    }

    public static boolean matchesAtLeastOnePattern(String path, String[] patterns) {
        boolean matches;
        boolean bl = matches = patterns == null || patterns.length == 0;
        if (!matches && patterns.length > 0) {
            int patternNumber = patterns.length;
            for (int ctr = 0; ctr < patternNumber; ++ctr) {
                String pattern = patterns[ctr];
                if (!PathMatcher.wildcardMatch(path, pattern)) continue;
                matches = true;
                break;
            }
        }
        return matches;
    }

    public static boolean modifiedAfter(long time, File directory) {
        File file;
        ArrayList files = new ArrayList();
        ResourceUtils.loadFiles(directory, files, true);
        boolean changed = files.isEmpty();
        Iterator iterator = files.iterator();
        while (iterator.hasNext() && !(changed = (file = (File)iterator.next()).lastModified() < time)) {
        }
        return changed;
    }

    public static String normalizePath(String path) {
        return path != null ? path.replaceAll(BACK_SLASH_NORMALIZATION_PATTERN, FORWARD_SLASH).replaceAll(FORWARD_SLASH_NORMALIZATION_PATTERN, FORWARD_SLASH) : null;
    }

    public static String renameExtension(String path, String oldExtension, String newExtension) {
        ExceptionUtils.checkEmpty("path", path);
        ExceptionUtils.checkNull("oldExtension", oldExtension);
        ExceptionUtils.checkNull("newExtension", newExtension);
        String newPath = path;
        int oldExtensionIndex = path.lastIndexOf(oldExtension);
        if (oldExtensionIndex != -1) {
            newPath = path.substring(0, oldExtensionIndex) + newExtension;
        }
        return newPath;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

