/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.CircularExtendsException;
import org.eclipse.birt.report.model.api.command.ExtendsException;
import org.eclipse.birt.report.model.api.command.ExtendsForbiddenException;
import org.eclipse.birt.report.model.api.command.InvalidParentException;
import org.eclipse.birt.report.model.api.command.PropertyNameException;
import org.eclipse.birt.report.model.api.command.WrongTypeException;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.api.elements.structures.PropertyMask;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IObjectDefn;
import org.eclipse.birt.report.model.api.metadata.ISlotDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.validators.SimpleListValidator;
import org.eclipse.birt.report.model.api.validators.StructureListValidator;
import org.eclipse.birt.report.model.api.validators.UnsupportedElementValidator;
import org.eclipse.birt.report.model.core.BackRef;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.IPropertySet;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.MultiElementSlot;
import org.eclipse.birt.report.model.core.PropertySearchStrategy;
import org.eclipse.birt.report.model.core.SingleElementSlot;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.TemplateParameterDefinition;
import org.eclipse.birt.report.model.elements.interfaces.IDesignElementModel;
import org.eclipse.birt.report.model.elements.strategy.CopyForPastePolicy;
import org.eclipse.birt.report.model.elements.strategy.CopyPolicy;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.IContainerDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.ReferenceValue;
import org.eclipse.birt.report.model.metadata.SlotDefn;
import org.eclipse.birt.report.model.metadata.StructRefValue;
import org.eclipse.birt.report.model.util.EncryptionUtil;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.util.ReferenceValueUtil;
import org.eclipse.birt.report.model.util.StructureContextUtil;
import org.eclipse.birt.report.model.validators.ValidationExecutor;
import org.eclipse.birt.report.model.validators.ValidationNode;

public abstract class DesignElement
implements IDesignElement,
IPropertySet,
IDesignElementModel {
    public static final long NO_BASE_ID = -1L;
    public static final long NO_ID = 0L;
    private static final int MAX_DISPLAY_LABEL_LEN = 30;
    protected String name = null;
    protected ArrayList<Listener> listeners = null;
    protected Map<String, Object> propValues = new HashMap<String, Object>(6);
    protected HashMap<String, UserPropertyDefn> userProperties = null;
    protected ContainerContext containerInfo = null;
    protected ContainerSlot[] slots = null;
    protected ElementRefValue extendsRef = null;
    protected ArrayList<DesignElement> derived = null;
    protected long id = 0L;
    protected IElementDefn cachedDefn = null;
    protected boolean isValid = true;
    protected DesignElementHandle handle = null;
    protected List<SemanticException> errors;
    protected long baseId = -1L;
    protected Map<String, String> encryptionMap = null;
    protected PropertySearchStrategy cachedPropStrategy = null;

    public DesignElement() {
        this((String)null);
    }

    public DesignElement(String theName) {
        this.name = StringUtil.trimString(theName);
        this.cachedDefn = MetaDataDictionary.getInstance().getElement(this.getElementName());
        this.cachedPropStrategy = PropertySearchStrategy.getInstance();
    }

    public DesignElement(IElementDefn elementDefn) {
        this.cachedDefn = elementDefn;
        this.cachedPropStrategy = PropertySearchStrategy.getInstance();
    }

    public void addListener(Listener obj) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (obj != null && !this.listeners.contains(obj)) {
            this.listeners.add(obj);
        }
    }

    public void removeListener(Listener obj) {
        if (this.listeners == null) {
            return;
        }
        int posn = this.listeners.indexOf(obj);
        if (posn != -1) {
            this.listeners.remove(posn);
        }
    }

    public void clearListeners() {
        if (this.listeners != null) {
            this.listeners.clear();
        }
        this.listeners = null;
    }

    public void sendEvent(NotificationEvent ev) {
        ev.setDeliveryPath(0);
        this.broadcast(ev);
    }

    public Module getRoot() {
        DesignElement element = this;
        while (element.getContainer() != null) {
            element = element.getContainer();
        }
        if (!(element instanceof Module)) {
            return null;
        }
        return (Module)element;
    }

    public final void broadcast(NotificationEvent ev) {
        if (this instanceof Module || this.getContainer() != null) {
            this.broadcast(ev, this.getRoot());
        }
    }

    public void broadcast(NotificationEvent ev, Module module) {
        if (this.listeners != null) {
            ArrayList<Listener> tmpListeners = new ArrayList<Listener>(this.listeners);
            Iterator<Listener> iter = tmpListeners.iterator();
            while (iter.hasNext()) {
                iter.next().elementChanged(this.getHandle(module), ev);
            }
        }
        if (this.derived != null) {
            if (ev.getDeliveryPath() == 4) {
                return;
            }
            if (ev.getDeliveryPath() != 2) {
                ev.setDeliveryPath(1);
            }
            Iterator<DesignElement> iter = this.derived.iterator();
            while (iter.hasNext()) {
                iter.next().broadcast(ev, module);
            }
        }
    }

    public final boolean isVirtualElement() {
        return this.baseId != -1L;
    }

    public final DesignElement getVirtualParent() {
        if (!this.isVirtualElement()) {
            return null;
        }
        DesignElement parent = null;
        DesignElement cur = this;
        while (cur != null) {
            DesignElement extendsElement = cur.getExtendsElement();
            if (extendsElement != null) {
                parent = extendsElement;
                break;
            }
            cur = cur.getContainer();
        }
        if (parent == null) {
            return null;
        }
        assert (parent.getContainer() instanceof Module);
        return parent.getRoot().getElementByID(this.baseId);
    }

    public final DesignElement getDynamicVirtualParent(Module module) {
        if (!this.isVirtualElement()) {
            return null;
        }
        DesignElement parent = null;
        DesignElement cur = this;
        while (cur != null) {
            DesignElement extendsElement = cur.getDynamicExtendsElement(module);
            if (extendsElement != null) {
                assert (cur.getExtendsElement() == null);
                parent = extendsElement;
                break;
            }
            cur = cur.getContainer();
        }
        if (parent == null) {
            return null;
        }
        assert (parent.getContainer() instanceof Module);
        return parent.getRoot().getElementByID(this.baseId);
    }

    public DesignElement getDynamicExtendsElement(Module module) {
        return null;
    }

    public Object getProperty(Module module, String propName) {
        ElementPropertyDefn prop = this.getPropertyDefn(propName);
        if (prop == null) {
            return null;
        }
        return this.getProperty(module, prop);
    }

    public Object getProperty(Module module, ElementPropertyDefn prop) {
        Object value = this.cachedPropStrategy.getPropertyExceptRomDefault(module, this, prop);
        if (value != null) {
            return value;
        }
        return prop.getDefault();
    }

    public PropertySearchStrategy getStrategy() {
        return this.cachedPropStrategy;
    }

    @Override
    public Object getProperty(Module module, PropertyDefn prop) {
        return this.getProperty(module, (ElementPropertyDefn)prop);
    }

    public boolean isStyle() {
        return false;
    }

    public Object getLocalProperty(Module module, String propName) {
        ElementPropertyDefn prop = this.getPropertyDefn(propName);
        if (prop == null) {
            return null;
        }
        return this.getLocalProperty(module, prop);
    }

    public Object getLocalProperty(Module module, ElementPropertyDefn prop) {
        boolean isEncryptable = prop.isEncryptable();
        if (prop.isIntrinsic()) {
            return isEncryptable ? EncryptionUtil.decrypt(this, prop, this.getIntrinsicProperty(prop.getName())) : this.getIntrinsicProperty(prop.getName());
        }
        switch (prop.getTypeCode()) {
            case 15: {
                this.resolveElementReference(module, prop);
                break;
            }
            case 19: {
                this.resolveStructReference(module, prop);
                break;
            }
            case 20: {
                if (prop.getSubTypeCode() != 15) break;
                return this.resolveElementReferenceList(module, prop);
            }
        }
        return isEncryptable ? EncryptionUtil.decrypt(this, prop, this.propValues.get(prop.getName())) : this.propValues.get(prop.getName());
    }

    protected Object getIntrinsicProperty(String propName) {
        if ("name".equals(propName)) {
            return this.getName();
        }
        if ("extends".equals(propName)) {
            if (this.extendsRef != null && !this.extendsRef.isResolved()) {
                ReferenceValueUtil.resloveExtends(this.getRoot(), this, this.extendsRef);
            }
            return this.extendsRef;
        }
        assert (false);
        return null;
    }

    protected void setIntrinsicProperty(String propName, Object value) {
        if (propName.equals("name")) {
            this.setName((String)value);
        } else assert (false);
    }

    public void setProperty(String propName, Object value) {
        ElementPropertyDefn prop = this.getPropertyDefn(propName);
        assert (prop != null);
        this.setProperty(prop, value);
    }

    public void setProperty(ElementPropertyDefn prop, Object value) {
        ReferenceValue oldRef;
        assert (prop != null);
        String propName = prop.getName();
        if (prop.isIntrinsic()) {
            this.setIntrinsicProperty(propName, value);
            return;
        }
        if (prop.getTypeCode() == 15) {
            oldRef = (ElementRefValue)this.propValues.get(propName);
            ReferenceValueUtil.updateReference(this, oldRef, (ReferenceValue)value, prop);
        }
        if (prop.getTypeCode() == 19) {
            oldRef = (StructRefValue)this.propValues.get(propName);
            ReferenceValueUtil.updateReference(this, oldRef, (StructRefValue)value, prop);
        }
        StructureContextUtil.setStructureContext(prop, value, this);
        if (value == null) {
            this.propValues.remove(propName);
        } else {
            this.propValues.put(propName, value);
        }
    }

    public String getPropertyMask(Module module, String propName) {
        DesignElement e = this;
        do {
            List masks;
            if ((masks = (List)e.getLocalProperty(module, "propertyMasks")) == null) continue;
            int i = 0;
            while (i < masks.size()) {
                PropertyMask mask = (PropertyMask)masks.get(i);
                if (propName.equals(mask.getName())) {
                    return mask.getMask();
                }
                ++i;
            }
        } while ((e = e.getExtendsElement()) != null);
        return null;
    }

    @Override
    public void setProperty(PropertyDefn prop, Object value) {
        this.setProperty((ElementPropertyDefn)prop, value);
    }

    public void clearProperty(String propName) {
        this.setProperty(propName, null);
    }

    @Override
    public IElementDefn getDefn() {
        return this.cachedDefn;
    }

    public void addUserPropertyDefn(UserPropertyDefn userProp) {
        assert (this.cachedDefn.allowsUserProperties());
        assert (userProp != null);
        String propName = userProp.getName();
        assert (this.getUserPropertyDefn(propName) == null);
        assert (this.cachedDefn.getProperty(propName) == null);
        if (this.userProperties == null) {
            this.userProperties = new LinkedHashMap<String, UserPropertyDefn>(6);
        }
        this.userProperties.put(propName, userProp);
    }

    public void dropUserPropertyDefn(UserPropertyDefn prop) {
        assert (this.cachedDefn.allowsUserProperties());
        assert (this.userProperties != null);
        assert (this.userProperties.get(prop.getName()) == prop);
        this.userProperties.remove(prop.getName());
    }

    public UserPropertyDefn getLocalUserPropertyDefn(String propName) {
        if (this.userProperties == null) {
            return null;
        }
        return this.userProperties.get(propName);
    }

    public UserPropertyDefn getUserPropertyDefn(String propName) {
        DesignElement e = this;
        while (e != null) {
            UserPropertyDefn p = e.getLocalUserPropertyDefn(propName);
            if (p != null) {
                return p;
            }
            DesignElement designElement = e = e.getExtendsElement() == null ? e.getVirtualParent() : e.getExtendsElement();
        }
        return null;
    }

    public DesignElement getExtendsElement() {
        if (this.extendsRef == null) {
            return null;
        }
        if (!this.extendsRef.isResolved()) {
            ReferenceValueUtil.resloveExtends(this.getRoot(), this, this.extendsRef);
        }
        return this.extendsRef.getElement();
    }

    public String getExtendsName() {
        if (this.extendsRef == null) {
            return null;
        }
        return StringUtil.buildQualifiedReference(this.extendsRef.getLibraryNamespace(), this.extendsRef.getName());
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.getName();
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public DesignElement getContainer() {
        return this.containerInfo == null ? null : this.containerInfo.container;
    }

    public ElementPropertyDefn getPropertyDefn(String propName) {
        if (propName == null) {
            return null;
        }
        ElementPropertyDefn prop = (ElementPropertyDefn)this.cachedDefn.getProperty(propName);
        if (prop == null) {
            prop = this.getUserPropertyDefn(propName);
        }
        return prop;
    }

    void validatePropertyName(String propName) throws PropertyNameException {
        if (this.getPropertyDefn(propName) == null) {
            throw new PropertyNameException(this, propName);
        }
    }

    public StyleElement getStyle(Module module) {
        return null;
    }

    public StyleElement getStyle() {
        return null;
    }

    public void addDerived(DesignElement child) {
        if (this.derived == null) {
            this.derived = new ArrayList();
        }
        assert (child != null);
        assert (child.getExtendsElement() == this);
        assert (!this.derived.contains(child));
        assert (child.cachedDefn == this.cachedDefn);
        this.derived.add(child);
    }

    public void dropDerived(DesignElement child) {
        assert (this.derived != null);
        assert (child != null);
        assert (child.getExtendsElement() == this);
        assert (this.derived.contains(child));
        this.derived.remove(child);
    }

    public void setExtendsElement(DesignElement base) {
        DesignElement oldExtends = this.getExtendsElement();
        if (base == oldExtends && base != null) {
            return;
        }
        if (oldExtends != null) {
            oldExtends.dropDerived(this);
        }
        if (base == null) {
            this.extendsRef = null;
        } else {
            assert (base.cachedDefn == this.cachedDefn);
            assert (base.getName() != null);
            String namespace = null;
            Module root = base.getRoot();
            if (root instanceof Library) {
                namespace = ((Library)root).getNamespace();
            }
            this.extendsRef = new ElementRefValue(namespace, base);
            base.addDerived(this);
        }
    }

    public TemplateParameterDefinition getTemplateParameterElement(Module module) {
        ElementRefValue templateParam = (ElementRefValue)this.getProperty(module, "refTemplateParameter");
        if (templateParam == null) {
            return null;
        }
        return (TemplateParameterDefinition)templateParam.getElement();
    }

    public List<DesignElement> getDescendents() {
        ArrayList<DesignElement> list = new ArrayList<DesignElement>();
        this.gatherDescendents(list);
        return list;
    }

    public void gatherDescendents(ArrayList<DesignElement> list) {
        if (this.derived == null) {
            return;
        }
        int i = 0;
        while (i < this.derived.size()) {
            DesignElement child = this.derived.get(i);
            list.add(child);
            child.gatherDescendents(list);
            ++i;
        }
    }

    public boolean hasUserProperties() {
        return this.userProperties != null && !this.userProperties.isEmpty();
    }

    public boolean hasLocalPropertyValues() {
        if (this.propValues.isEmpty()) {
            return false;
        }
        for (String propName : this.propValues.keySet()) {
            ElementPropertyDefn propDefn = this.getPropertyDefn(propName);
            if (propDefn.isListType() && !((List)this.propValues.get(propName)).isEmpty()) {
                return true;
            }
            if (propDefn.getTypeCode() == 23) continue;
            return true;
        }
        return false;
    }

    public Iterator<String> propertyWithLocalValueIterator() {
        return this.propValues.keySet().iterator();
    }

    public ContainerSlot getSlot(int slot) {
        return null;
    }

    public List<UserPropertyDefn> getUserProperties() {
        ArrayList<UserPropertyDefn> props = new ArrayList<UserPropertyDefn>();
        DesignElement e = this;
        while (e != null) {
            List<UserPropertyDefn> prop = e.getLocalUserProperties();
            if (prop != null) {
                props.addAll(prop);
            }
            DesignElement designElement = e = e.getExtendsElement() == null ? e.getVirtualParent() : e.getExtendsElement();
        }
        return props;
    }

    public List<UserPropertyDefn> getLocalUserProperties() {
        if (this.userProperties == null) {
            return Collections.emptyList();
        }
        return new ArrayList<UserPropertyDefn>(this.userProperties.values());
    }

    public boolean isKindOf(DesignElement element) {
        DesignElement e = this;
        while (e != null) {
            if (e == element) {
                return true;
            }
            e = e.getExtendsElement();
        }
        return false;
    }

    public boolean hasDerived() {
        return this.derived != null && this.derived.size() > 0;
    }

    public String getDisplayName() {
        return (String)this.getProperty(null, "displayName");
    }

    public String getDisplayNameID() {
        return (String)this.getLocalProperty(null, "displayNameID");
    }

    public void setID(long newID) {
        this.id = newID;
    }

    public long getID() {
        return this.id;
    }

    public boolean isContentOf(DesignElement element) {
        DesignElement e = this;
        while (e != null) {
            if (e == element) {
                return true;
            }
            e = e.getContainer();
        }
        return false;
    }

    public BigDecimal getNumberProperty(Module module, String propName) {
        ElementPropertyDefn prop = this.getPropertyDefn(propName);
        if (prop == null) {
            return null;
        }
        Object value = this.getProperty(module, prop);
        return prop.getNumberValue(module, value);
    }

    public abstract void apply(ElementVisitor var1);

    public String getStringProperty(Module module, String propName) {
        ElementPropertyDefn prop = this.getPropertyDefn(propName);
        if (prop == null) {
            return null;
        }
        Object value = this.getProperty(module, prop);
        return prop.getStringValue(module, value);
    }

    public String getDisplayProperty(Module module, String propName) {
        ElementPropertyDefn prop = this.getPropertyDefn(propName);
        if (prop == null) {
            return null;
        }
        return this.getDisplayProperty(module, prop);
    }

    public String getDisplayProperty(Module module, PropertyDefn prop) {
        Object value = this.getProperty(module, prop);
        if (value == null) {
            return null;
        }
        return prop.getDisplayValue(module, value);
    }

    public void setExtendsName(String name) {
        this.setExtendsElement(null);
        name = StringUtil.trimString(name);
        if (name == null) {
            return;
        }
        String namespace = StringUtil.extractNamespace(name);
        name = StringUtil.extractName(name);
        this.extendsRef = new ElementRefValue(namespace, name);
    }

    public final List<SemanticException> validateWithContents(Module module) {
        ElementDefn elementDefn = (ElementDefn)this.cachedDefn;
        List<ValidationNode> validatorList = ValidationExecutor.getValidationNodes(this, elementDefn.getTriggerDefnSet(), true);
        ValidationExecutor executor = module.getValidationExecutor();
        this.errors = executor.perform(this, validatorList);
        ArrayList<SemanticException> list = new ArrayList<SemanticException>(this.errors);
        Iterator<ISlotDefn> slotIter = ((ElementDefn)this.cachedDefn).slotsIterator();
        while (slotIter.hasNext()) {
            ISlotDefn slotDefn = slotIter.next();
            int slotId = slotDefn.getSlotID();
            Iterator<DesignElement> iter = this.getSlot(slotId).iterator();
            while (iter.hasNext()) {
                list.addAll(iter.next().validateWithContents(module));
            }
        }
        List<IElementPropertyDefn> contentProps = this.cachedDefn.getContents();
        int i = 0;
        while (i < contentProps.size()) {
            IElementPropertyDefn tmpContentProp = contentProps.get(i);
            Object tmpElements = this.getLocalProperty(module, (ElementPropertyDefn)tmpContentProp);
            if (tmpElements != null) {
                if (tmpElements instanceof DesignElement) {
                    list.addAll(((DesignElement)tmpElements).validateWithContents(module));
                } else if (tmpElements instanceof List) {
                    Iterator iter = ((List)tmpElements).iterator();
                    while (iter.hasNext()) {
                        list.addAll(((DesignElement)iter.next()).validateWithContents(module));
                    }
                }
            }
            ++i;
        }
        return list;
    }

    public List<SemanticException> validate(Module module) {
        this.errors = new ArrayList<SemanticException>();
        this.errors.addAll(UnsupportedElementValidator.getInstance().validate(module, this));
        List propMasks = (List)this.getLocalProperty(module, "propertyMasks");
        if (propMasks != null) {
            ListIterator masks = propMasks.listIterator();
            while (masks.hasNext()) {
                PropertyMask mask = (PropertyMask)masks.next();
                this.errors.addAll(mask.validate(module, this));
            }
        }
        return this.errors;
    }

    protected List<SemanticException> validateStructureList(Module module, String propName) {
        return StructureListValidator.getInstance().validate(module, this, propName);
    }

    public List<String> getElementSelectors() {
        ArrayList<String> list = new ArrayList<String>();
        String selector = ((ElementDefn)this.cachedDefn).getSelector();
        if (selector != null) {
            list.add(selector);
        }
        return list;
    }

    public void checkStructureList(Module module, PropertyDefn propDefn, List<Object> list, IStructure toAdd) throws PropertyValueException {
        List<SemanticException> errorList = StructureListValidator.getInstance().validateForAdding(this.getHandle(module), propDefn, list, toAdd);
        if (errorList.size() > 0) {
            throw (PropertyValueException)errorList.get(0);
        }
    }

    public void checkExtends(DesignElement parent) throws ExtendsException {
        String extendsName = this.getExtendsName();
        IElementDefn defn = this.cachedDefn;
        if (parent == null) {
            throw new InvalidParentException(this, extendsName, "Error.InvalidParentException.PARENT_NOT_FOUND");
        }
        if (!defn.canExtend()) {
            throw new ExtendsForbiddenException(this, parent.getName(), "Error.ExtendsForbiddenException.CANT_EXTEND");
        }
        if (parent.cachedDefn != defn) {
            throw new WrongTypeException(this, parent, "Error.WrongTypeException.WRONG_TYPE");
        }
        if (parent == this) {
            throw new CircularExtendsException(this, extendsName, "Error.CircularExtendsException.SELF_EXTEND");
        }
        if (parent.isKindOf(this)) {
            throw new CircularExtendsException(this, parent, "Error.CircularExtendsException.CIRCULAR");
        }
    }

    public int getIntProperty(Module module, String propName) {
        ElementPropertyDefn prop = this.getPropertyDefn(propName);
        if (prop == null) {
            return 0;
        }
        Object value = this.getProperty(module, prop);
        return prop.getIntValue(module, value);
    }

    public double getFloatProperty(Module module, String propName) {
        ElementPropertyDefn prop = this.getPropertyDefn(propName);
        if (prop == null) {
            return 0.0;
        }
        Object value = this.getProperty(module, prop);
        return prop.getFloatValue(module, value);
    }

    public boolean getBooleanProperty(Module module, String propName) {
        ElementPropertyDefn prop = this.getPropertyDefn(propName);
        if (prop == null) {
            return false;
        }
        Object value = this.getProperty(module, prop);
        return prop.getBooleanValue(module, value);
    }

    public List<Object> getListProperty(Module module, String propName) {
        Object value = this.getProperty(module, propName);
        if (value == null) {
            return null;
        }
        if (value instanceof ArrayList) {
            return (ArrayList)value;
        }
        return null;
    }

    public List<IElementPropertyDefn> getPropertyDefns() {
        List<IElementPropertyDefn> list = this.cachedDefn.getProperties();
        List<UserPropertyDefn> userProps = this.getUserProperties();
        if (userProps != null) {
            list.addAll(userProps);
        }
        return list;
    }

    public abstract String getElementName();

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof DesignElementHandle) {
            return ((DesignElementHandle)obj).getElement() == this;
        }
        return false;
    }

    public int findSlotOf(DesignElement content) {
        if (content == null || content.getContainer() != this) {
            return -1;
        }
        return content.getContainerInfo().getSlotID();
    }

    public boolean canEdit(Module module) {
        return !this.isRootIncludedByModule() && (module == null || !module.isReadOnly());
    }

    public boolean canDrop(Module module) {
        List<BackRef> clients;
        if (this.isRootIncludedByModule() || module != null && module.isReadOnly()) {
            return false;
        }
        if (this.isVirtualElement()) {
            return false;
        }
        if (this.getContainer() instanceof TemplateParameterDefinition) {
            assert (this.getContainerInfo().getSlotID() == 0);
            return false;
        }
        DesignElement element = this;
        return !(element instanceof TemplateParameterDefinition) || (clients = ((TemplateParameterDefinition)element).getClientList()).size() == 0;
    }

    public boolean isRootIncludedByModule() {
        Module tmpContainer = this.getRoot();
        return tmpContainer == null ? false : tmpContainer.isReadOnly();
    }

    public List<SemanticException> checkContent(Module module, ContainerContext containerInfo, DesignElement content) {
        return new ArrayList<SemanticException>();
    }

    public List<SemanticException> checkContent(Module module, ContainerContext containerInfo, IElementDefn defn) {
        return new ArrayList<SemanticException>();
    }

    public ContainerContext getContainerInfo() {
        return this.containerInfo;
    }

    @Override
    public IObjectDefn getObjectDefn() {
        return this.cachedDefn;
    }

    public DesignElement getReferenceProperty(Module module, String propName) {
        ElementRefValue ref = (ElementRefValue)this.getProperty(module, propName);
        if (ref == null) {
            return null;
        }
        return ref.getElement();
    }

    public boolean hasReferences() {
        return false;
    }

    public Object getFactoryProperty(Module module, ElementPropertyDefn prop) {
        assert (!prop.isStyleProperty());
        return this.cachedPropStrategy.getPropertyExceptRomDefault(module, this, prop);
    }

    public Object getFactoryProperty(Module module, ElementPropertyDefn prop, boolean forExport) {
        return this.getFactoryProperty(module, prop);
    }

    public Object getFactoryProperty(Module module, String propName) {
        ElementPropertyDefn prop = this.getPropertyDefn(propName);
        if (prop == null) {
            return null;
        }
        return this.getFactoryProperty(module, prop);
    }

    public List<DesignElement> getDerived() {
        if (this.derived != null) {
            return new ArrayList<DesignElement>(this.derived);
        }
        return new ArrayList<DesignElement>();
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    public String getDisplayLabel(Module module, int level) {
        ULocale locale = module == null ? ThreadResources.getLocale() : module.getLocale();
        String displayLabel = ModelUtil.searchForExternalizedValue(this, "displayNameID", locale);
        if (StringUtil.isBlank(displayLabel)) {
            displayLabel = this.getDisplayName();
        }
        if (StringUtil.isBlank(displayLabel)) {
            displayLabel = this.getNameForDisplayLabel();
        }
        if (level == 0) {
            return displayLabel;
        }
        if (!StringUtil.isBlank(displayLabel)) {
            return displayLabel;
        }
        return this.getDefnDisplayName(module);
    }

    protected String getDefnDisplayName(Module module) {
        MetaDataDictionary dictionary = MetaDataDictionary.getInstance();
        IElementDefn elementDefn = dictionary.getElement(this.getElementName());
        String displayLabel = elementDefn.getDisplayName();
        if (StringUtil.isBlank(displayLabel)) {
            displayLabel = elementDefn.getName();
        }
        return displayLabel;
    }

    protected String getNameForDisplayLabel() {
        return this.getName();
    }

    protected String limitStringLength(String displayLabel) {
        if (displayLabel == null) {
            return null;
        }
        if (displayLabel.length() > 30) {
            int pos = (displayLabel = displayLabel.substring(0, 30)).lastIndexOf(" ");
            if (pos != -1) {
                displayLabel = displayLabel.substring(0, pos);
            }
            return String.valueOf(displayLabel) + "...";
        }
        return displayLabel;
    }

    @Override
    public final Object clone() throws CloneNotSupportedException {
        return this.doClone(CopyForPastePolicy.getInstance());
    }

    public Object doClone(CopyPolicy policy) throws CloneNotSupportedException {
        DesignElement element = (DesignElement)this.baseClone();
        if (policy != null) {
            policy.execute(this, element);
        }
        for (String key : this.propValues.keySet()) {
            Object clonedValue;
            Object value;
            ElementPropertyDefn propDefn = this.getPropertyDefn(key);
            if (!propDefn.isElementType() || (value = this.propValues.get(propDefn.getName())) == null || (clonedValue = ModelUtil.copyValue(propDefn, value, policy)) == null) continue;
            element.propValues.put(key, clonedValue);
            if (propDefn.isList()) {
                List values = (List)clonedValue;
                int i = 0;
                while (i < values.size()) {
                    DesignElement item = (DesignElement)values.get(i);
                    item.setContainer(element, key);
                    ++i;
                }
                continue;
            }
            ((DesignElement)clonedValue).setContainer(element, key);
        }
        int slotCount = this.cachedDefn.getSlotCount();
        Iterator<ISlotDefn> iter1 = ((ElementDefn)this.cachedDefn).slotsIterator();
        if (slotCount > 0) {
            element.slots = new ContainerSlot[slotCount];
            int i = 0;
            while (i < slotCount) {
                SlotDefn slot = (SlotDefn)iter1.next();
                element.slots[i] = this.slots[i].copy(element, slot.getSlotID(), policy);
                ++i;
            }
        }
        return element;
    }

    protected final void initSlots() {
        int slotCount = this.cachedDefn.getSlotCount();
        if (slotCount == 0) {
            return;
        }
        Iterator<ISlotDefn> iter1 = ((ElementDefn)this.cachedDefn).slotsIterator();
        this.slots = new ContainerSlot[slotCount];
        int i = 0;
        while (i < slotCount) {
            SlotDefn slot = (SlotDefn)iter1.next();
            this.slots[i] = slot.isMultipleCardinality() ? new MultiElementSlot() : new SingleElementSlot();
            ++i;
        }
    }

    public List<SemanticException> getErrors() {
        if (this.errors == null) {
            return new ArrayList<SemanticException>();
        }
        return this.errors;
    }

    public String getIdentifier() {
        if (this.getFullName() != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.cachedDefn.getDisplayName());
            sb.append("(\"");
            sb.append(this.getFullName());
            sb.append("\")");
            return sb.toString();
        }
        if (this instanceof ReportDesign) {
            return "report";
        }
        if (this instanceof Library) {
            return "library";
        }
        if (this.getContainer() == null) {
            return this.cachedDefn.getName();
        }
        IContainerDefn containerDefn = this.getContainerInfo().getContainerDefn();
        StringBuffer sb = new StringBuffer();
        sb.append(this.getContainer().getIdentifier());
        sb.append(".");
        sb.append(containerDefn.getDisplayName());
        sb.append("[");
        sb.append(this.getContainerInfo().indexOf(this));
        sb.append("]");
        return sb.toString();
    }

    public void setBaseId(long baseId) {
        this.baseId = baseId;
    }

    public long getBaseId() {
        return this.baseId;
    }

    public void clearAllProperties() {
        this.name = null;
        this.extendsRef = null;
        this.propValues.clear();
    }

    public boolean isManagedByNameSpace() {
        int nameOption = this.getDefn().getNameOption();
        if (nameOption == 0) {
            return false;
        }
        ContainerContext infor = this.getContainerInfo();
        if (infor == null) {
            return false;
        }
        return this.getContainerInfo().isManagedByNameSpace();
    }

    public final boolean canTransformToTemplate(Module module) {
        if (!ModelUtil.isTemplateSupported(this) || !this.canDrop(module)) {
            return false;
        }
        IElementDefn templateReportItem = MetaDataDictionary.getInstance().getElement("TemplateReportItem");
        IElementDefn templateDataSet = MetaDataDictionary.getInstance().getElement("TemplateDataSet");
        DesignElement container = this.getContainer();
        if (container != null) {
            ContainerContext containerInfor = this.getContainerInfo();
            return containerInfor.canContain(module, templateReportItem) || containerInfor.canContain(module, templateDataSet);
        }
        return true;
    }

    public boolean isTemplateParameterValue(Module module) {
        return this.getTemplateParameterElement(module) != null;
    }

    public void checkSimpleList(Module module, PropertyDefn propDefn, List<Object> list, Object toAdd) throws PropertyValueException {
        List<SemanticException> errorList = SimpleListValidator.getInstance().validateForAdding(this.getHandle(module), propDefn, list, toAdd);
        if (errorList.size() > 0) {
            throw (PropertyValueException)errorList.get(0);
        }
    }

    protected Object baseClone() throws CloneNotSupportedException {
        DesignElement element = (DesignElement)super.clone();
        element.containerInfo = null;
        element.listeners = null;
        element.derived = null;
        element.handle = null;
        element.propValues = new HashMap<String, Object>();
        if (this.encryptionMap != null && !this.encryptionMap.isEmpty()) {
            element.encryptionMap = new HashMap<String, String>();
            element.encryptionMap.putAll(this.encryptionMap);
        }
        if (this.extendsRef != null) {
            element.extendsRef = (ElementRefValue)this.extendsRef.copy();
        }
        Iterator<String> iter = null;
        if (!this.isVirtualElement() && this.userProperties != null) {
            element.userProperties = new LinkedHashMap<String, UserPropertyDefn>(6);
            for (String key : this.userProperties.keySet()) {
                UserPropertyDefn uDefn = this.userProperties.get(key);
                element.userProperties.put(key, (UserPropertyDefn)uDefn.copy());
            }
        }
        for (String key : this.propValues.keySet()) {
            Object clonedValue;
            ElementPropertyDefn propDefn = this.getPropertyDefn(key);
            Object value = this.propValues.get(key);
            if (value == null || propDefn.isElementType() || (clonedValue = ModelUtil.copyValue(propDefn, value)) == null) continue;
            element.propValues.put(key, clonedValue);
            if (propDefn.getTypeCode() != 16) continue;
            StructureContextUtil.setStructureContext(propDefn, clonedValue, element);
        }
        return element;
    }

    void setContainer(DesignElement obj, int slot) {
        this.containerInfo = new ContainerContext(obj, slot);
    }

    public void setContainer(DesignElement obj, String propName) {
        this.containerInfo = new ContainerContext(obj, propName);
    }

    public void add(DesignElement content, int slotID) {
        this.getSlot(slotID).add(content);
        content.setContainer(this, slotID);
    }

    public void add(DesignElement content, int slotID, int posn) {
        this.getSlot(slotID).insert(content, posn);
        content.setContainer(this, slotID);
    }

    public void remove(DesignElement content, int slotID) {
        this.getSlot(slotID).remove(content);
        content.containerInfo = null;
    }

    public void add(Module module, DesignElement content, String propName) {
        ElementPropertyDefn defn = this.getPropertyDefn(propName);
        if (defn != null) {
            if (defn.isList()) {
                ArrayList<DesignElement> values = (ArrayList<DesignElement>)this.getLocalProperty(module, propName);
                if (values == null) {
                    values = new ArrayList<DesignElement>();
                }
                if (!values.contains(content)) {
                    values.add(content);
                }
                this.setProperty(propName, values);
                content.setContainer(this, propName);
            } else {
                this.setProperty(defn, (Object)content);
                content.setContainer(this, propName);
            }
        }
    }

    public void add(Module module, DesignElement content, String propName, int posn) {
        ElementPropertyDefn defn = this.getPropertyDefn(propName);
        if (defn != null) {
            if (defn.isList()) {
                ArrayList<DesignElement> values = (ArrayList<DesignElement>)this.getLocalProperty(module, propName);
                if (values == null) {
                    values = new ArrayList<DesignElement>();
                }
                if (!values.contains(content)) {
                    values.add(posn, content);
                }
                this.setProperty(propName, values);
                content.setContainer(this, propName);
            } else {
                assert (posn == 0);
                this.setProperty(defn, (Object)content);
                content.setContainer(this, propName);
            }
        }
    }

    public void remove(Module module, DesignElement content, String propName) {
        ElementPropertyDefn defn = this.getPropertyDefn(propName);
        if (defn != null) {
            if (content.getRoot() != null && module != content.getRoot()) {
                return;
            }
            if (defn.isList()) {
                List values = (List)this.getLocalProperty(module, propName);
                if (values != null) {
                    values.remove(content);
                    content.containerInfo = null;
                }
            } else {
                this.clearProperty(propName);
                content.containerInfo = null;
            }
        }
    }

    public List<ElementRefValue> resolveElementReferenceList(Module module, ElementPropertyDefn prop) {
        Object value = this.propValues.get(prop.getName());
        assert (value == null || value instanceof List);
        assert (prop.getTypeCode() == 20 && prop.getSubTypeCode() == 15);
        if (value == null) {
            return null;
        }
        List valueList = (List)value;
        int i = 0;
        while (i < valueList.size()) {
            ElementRefValue item = (ElementRefValue)valueList.get(i);
            ReferenceValueUtil.resolveElementReference(module, this, prop, item);
            ++i;
        }
        return valueList;
    }

    public ElementRefValue resolveElementReference(Module module, ElementPropertyDefn prop) {
        Object value = this.propValues.get(prop.getName());
        assert (value == null || value instanceof ElementRefValue);
        assert (prop.getTypeCode() == 15);
        if (!(value instanceof ElementRefValue)) {
            return null;
        }
        if (module == null) {
            return null;
        }
        return ReferenceValueUtil.resolveElementReference(module, this, prop, (ElementRefValue)value);
    }

    public StructRefValue resolveStructReference(Module module, ElementPropertyDefn prop) {
        Object value = this.propValues.get(prop.getName());
        if (!(value instanceof StructRefValue)) {
            return null;
        }
        if (module == null) {
            return null;
        }
        return ReferenceValueUtil.resolveStructReference(module, this, prop, (StructRefValue)value);
    }

    public int getIndex(Module module) {
        ContainerContext containerContext = this.getContainerInfo();
        return containerContext == null ? -1 : containerContext.indexOf(module, this);
    }

    public String getLocalEncryptionID(ElementPropertyDefn propDefn) {
        if (this.encryptionMap != null && this.encryptionMap.get(propDefn.getName()) != null) {
            String encryptionID = this.encryptionMap.get(propDefn.getName());
            return encryptionID;
        }
        return null;
    }

    public String getEncryptionID(ElementPropertyDefn propDefn) {
        if (propDefn == null || !propDefn.isEncryptable()) {
            return null;
        }
        DesignElement e = this;
        while (e != null) {
            String encryption = e.getLocalEncryptionID(propDefn);
            if (encryption != null) {
                return encryption;
            }
            DesignElement designElement = e = e.getExtendsElement() == null ? e.getVirtualParent() : e.getExtendsElement();
        }
        return MetaDataDictionary.getInstance().getDefaultEncryptionHelperID();
    }

    protected boolean hasLocalValue(ElementPropertyDefn propDefn) {
        if (propDefn == null) {
            return false;
        }
        if (propDefn.isIntrinsic()) {
            return this.getIntrinsicProperty(propDefn.getName()) != null;
        }
        return this.propValues.get(propDefn.getName()) != null;
    }

    public final void setEncryptionHelper(String propName, String encryptionID) {
        ElementPropertyDefn prop = this.getPropertyDefn(propName);
        if (prop == null || !prop.isEncryptable()) {
            return;
        }
        this.setEncryptionHelper(prop, encryptionID);
    }

    public void setEncryptionHelper(ElementPropertyDefn propDefn, String encryptionID) {
        if (propDefn == null || !propDefn.isEncryptable()) {
            return;
        }
        String id = StringUtil.trimString(encryptionID);
        if (this.encryptionMap == null) {
            this.encryptionMap = new HashMap<String, String>();
        }
        if (id == null) {
            this.encryptionMap.remove(propDefn.getName());
        } else {
            this.encryptionMap.put(propDefn.getName(), id);
        }
    }

    public boolean isInTemplateParameterDefinitionSlot() {
        return this.isInSlot(8);
    }

    public boolean isInSlot(int slotID) {
        int slot;
        DesignElement tmpContainer = this.getContainer();
        ContainerContext containerInfo = null;
        while (tmpContainer != null && !(tmpContainer instanceof Module)) {
            containerInfo = tmpContainer.getContainerInfo();
            tmpContainer = tmpContainer.getContainer();
        }
        int n = slot = containerInfo == null ? -1 : containerInfo.getSlotID();
        return slotID == slot;
    }

    public PropertySearchStrategy getPropertySearchStrategy() {
        return this.cachedPropStrategy;
    }

    public int getSlotIndex(int slotID) {
        return slotID;
    }

    public List<IElementPropertyDefn> getContents() {
        return this.cachedDefn.getContents();
    }

    public final boolean isContainer() {
        if (this.cachedDefn.isContainer()) {
            return true;
        }
        return !this.getContents().isEmpty();
    }

    public boolean canDynamicExtends() {
        return false;
    }
}

