/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.report;

import fr.ifremer.tutti.report.ReportConfig;
import java.io.Closeable;
import java.io.File;
import java.util.HashMap;
import java.util.logging.Level;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportEngineFactory;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.RenderOption;

public class ReportEngine
implements Closeable {
    private static final int RENDER_DPI = 300;
    private final IReportEngine engine;

    public ReportEngine(File reportHomeDirectory, File reportLogDirectory) {
        EngineConfig engineConfig = new EngineConfig();
        engineConfig.setBIRTHome(reportHomeDirectory.getAbsolutePath());
        engineConfig.setResourcePath(reportHomeDirectory.getAbsolutePath());
        engineConfig.setLogConfig(reportLogDirectory.getAbsolutePath(), Level.FINEST);
        try {
            Platform.startup(engineConfig);
        }
        catch (BirtException e) {
            throw new RuntimeException("Could not init birt", e);
        }
        IReportEngineFactory factory = (IReportEngineFactory)Platform.createFactoryObject("org.eclipse.birt.report.engine.ReportEngineFactory");
        this.engine = factory.createReportEngine(engineConfig);
    }

    public void generate(ReportConfig reportConfig) {
        IReportRunnable rptDoc;
        try {
            rptDoc = this.engine.openReportDesign(reportConfig.getReportFile().getAbsolutePath());
        }
        catch (EngineException e) {
            throw new RuntimeException("Could not get report " + reportConfig.getReportFile(), e);
        }
        try (IRunAndRenderTask task = this.engine.createRunAndRenderTask(rptDoc);){
            RenderOption renderOption = new RenderOption();
            renderOption.setOutputFileName(reportConfig.getOutputFile().getAbsolutePath());
            renderOption.setOutputFormat("pdf");
            task.setRenderOption(renderOption);
            HashMap<String, Integer> context = new HashMap<String, Integer>();
            context.put("CHART_RESOLUTION", 300);
            task.setAppContext(context);
            task.setParameterValue("rpt-param_dirfile", reportConfig.getDataDirectory().getAbsolutePath());
            task.setParameterValue("rpt-param_codestation", reportConfig.getStationNumber());
            task.setParameterValue("rpt-param_numerotrait", reportConfig.getFishingOperationNumber());
            task.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.engine.destroy();
        }
        finally {
            Platform.shutdown();
        }
    }
}

