/* *##% 
 * SuiviObsmer :: Web Interface
 * Copyright (C) 2009 - 2010 Ifremer
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*/

package fr.ifremer.suiviobsmer.ui.services;

import fr.ifremer.suiviobsmer.services.*;
import fr.ifremer.suiviobsmer.impl.*;

import org.apache.tapestry5.SymbolConstants;
import org.apache.tapestry5.ioc.MappedConfiguration;
import org.apache.tapestry5.ioc.OrderedConfiguration;
import org.apache.tapestry5.ioc.ServiceBinder;
import org.apache.tapestry5.ioc.annotations.EagerLoad;
import org.apache.tapestry5.ioc.annotations.InjectService;
import org.apache.tapestry5.ioc.services.RegistryShutdownHub;
import org.apache.tapestry5.ioc.services.RegistryShutdownListener;

/**
 * This module is automatically included as part of the Tapestry IoC Registry,
 * it's a good place to configure and extend Tapestry, or to place your own
 * service definitions.
 *
 * @version $Id: AppModule.java 2766 2009-08-27 16:29:23Z nrannou $
 */
public class AppModule {

    public static void bind(ServiceBinder binder) {
        // binder.bind(MyServiceInterface.class, MyServiceImpl.class);

        // Make bind() calls on the binder object to define most IoC services.
        // Use service builder methods (example below) when the implementation
        // is provided inline, or requires more initialization than simply
        // invoking the constructor.
        binder.bind(ServiceNews.class, ServiceNewsImpl.class);
        binder.bind(ServiceUser.class, ServiceUserImpl.class);
        binder.bind(ServiceSampling.class, ServiceSamplingImpl.class);
        binder.bind(ServiceReferential.class, ServiceReferentialImpl.class);
        binder.bind(ServiceBoat.class, ServiceBoatImpl.class);
        binder.bind(ServiceContact.class, ServiceContactImpl.class);
        binder.bind(ContactModelFactory.class);
        binder.bind(ServiceSynthesis.class, ServiceSynthesisImpl.class);
//        binder.bind(SuiviObsmerModelDAOHelper.getContractClass(User.class),
//                SuiviObsmerModelDAOHelper.getImplementationClass(User.class));
    }

    public static void contributeApplicationDefaults(
            MappedConfiguration<String, String> configuration) {
        // Contributions to ApplicationDefaults will override any contributions to
        // FactoryDefaults (with the same key). Here we're restricting the supported
        // locales to just "en" (English). As you add localised message catalogs and other assets,
        // you can extend this list of locales (it's a comma separated series of locale names;
        // the first locale name is the default when there's no reasonable match).

        configuration.add(SymbolConstants.SUPPORTED_LOCALES, "fr,en");

        // The factory default is true but during the early stages of an application
        // overriding to false is a good idea. In addition, this is often overridden
        // on the command line as -Dtapestry.production-mode=false
        configuration.add(SymbolConstants.PRODUCTION_MODE, "false");
    }

    /**
     * This is a service definition, the service will be named "TimingFilter".
     * The interface, RequestFilter, is used within the RequestHandler service
     * pipeline, which is built from the RequestHandler service configuration.
     * Tapestry IoC is responsible for passing in an appropriate Logger
     * instance. Requests for static resources are handled at a higher level, so
     * this filter will only be invoked for Tapestry related requests.
     *
     * <p>
     * Service builder methods are useful when the implementation is inline as
     * an inner class (as here) or require some other kind of special
     * initialization. In most cases, use the static bind() method instead.
     *
     * <p>
     * If this method was named "build", then the service id would be taken from
     * the service interface and would be "RequestFilter". Since Tapestry
     * already defines a service named "RequestFilter" we use an explicit
     * service id that we can reference inside the contribution method.
     */
    /*public RequestFilter buildTimingFilter(final Logger log) {
        return new RequestFilter() {
            public boolean service(Request request, Response response,
                    RequestHandler handler) throws IOException {
                long startTime = System.currentTimeMillis();

                try {
                    // The responsibility of a filter is to invoke the corresponding method
                    // in the handler. When you chain multiple filters together, each filter
                    // received a handler that is a bridge to the next filter.

                    return handler.service(request, response);
                } finally {
                    long elapsed = System.currentTimeMillis() - startTime;

                    log.info(String.format("Request time: %d ms", elapsed));
                }
            }
        };
    }*/

    /**
     * This is the Shutdown service definition. This service is used when the
     * server shutdown. It detects the Tapestry registry shutdown.
     * @param hub
     * @return 
     */
    @EagerLoad
    public RegistryShutdownListener buildSuiviObsmerShutdown(
            @InjectService("RegistryShutdownHub") RegistryShutdownHub hub) {
        RegistryShutdownListener listener = new SuiviObsmerManager();
        hub.addRegistryShutdownListener(listener);
        return listener;
    }

    public static void contributeRegistryStartup(OrderedConfiguration<Runnable> configuration) {
        configuration.add("SuiviObsmerStartup", new SuiviObsmerManager());
    }

}
