/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.util;

import java.io.BufferedReader;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleParser {
    private static Log log = LogFactory.getLog(SimpleParser.class);
    private static final int MARK_SIZE = 2;
    protected boolean intern;
    protected BufferedReader in;
    protected StringBuilder sb = new StringBuilder();
    protected boolean eof = false;
    protected boolean eol = false;

    public SimpleParser(BufferedReader in, boolean intern) {
        this.in = in;
        this.intern = intern;
    }

    public boolean isEOF() {
        return this.eof;
    }

    public boolean isEOL() {
        return this.eol;
    }

    protected void read(char sep) throws IOException {
        int i;
        this.eol = false;
        this.sb.setLength(0);
        while ((i = this.in.read()) != -1) {
            char c = (char)i;
            if (c == '\r') {
                this.in.mark(2);
                c = (char)this.in.read();
                if (c != '\n') {
                    this.in.reset();
                }
                this.eol = true;
                break;
            }
            if (c == '\n') {
                this.eol = true;
                break;
            }
            if (c == sep) break;
            this.sb.append(c);
        }
        if (i != -1) {
            this.in.mark(2);
            i = this.in.read();
            this.in.reset();
        }
        this.eof = i == -1;
    }

    public String readString(char sep) throws IOException {
        this.read(sep);
        String result = this.sb.toString();
        if (this.intern) {
            result = result.intern();
        }
        return result;
    }

    public int readInt(char sep) throws IOException {
        this.read(sep);
        int result = this.parseInt(this.sb);
        return result;
    }

    public double readDouble(char sep) throws IOException {
        this.read(sep);
        double result = this.parseDouble(this.sb);
        return result;
    }

    protected double parseDouble(StringBuilder s) throws IOException {
        return Double.parseDouble(s.toString());
    }

    protected int parseInt(StringBuilder sb) {
        int result = 0;
        int maxi = sb.length();
        for (int i = 0; i < maxi; ++i) {
            char c = sb.charAt(i);
            result = result * 10 + c - 48;
        }
        return result;
    }
}

