/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.util;

import fr.ifremer.isisfish.entities.Cell;
import java.awt.geom.Point2D;
import java.util.Comparator;

public class CellPointcomparator
implements Comparator<Object> {
    @Override
    public int compare(Object o1, Object o2) {
        float lon2;
        float lat2;
        Point2D point;
        float lon1;
        float lat1;
        Cell cell;
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            throw new IllegalArgumentException("if o1 is null, o2 must be null");
        }
        if (o2 == null) {
            throw new IllegalArgumentException("if o2 is null, o1 must be null");
        }
        if (!(o1 instanceof Cell) && !(o1 instanceof Point2D)) {
            throw new IllegalArgumentException("o1 is not Cell or Point2D: " + o1.getClass().getName());
        }
        if (!(o2 instanceof Cell) && !(o2 instanceof Point2D)) {
            throw new IllegalArgumentException("o2 is not Cell or Point2D: " + o2.getClass().getName());
        }
        if (o1 instanceof Cell) {
            cell = (Cell)o1;
            lat1 = cell.getLatitude();
            lon1 = cell.getLongitude();
        } else {
            point = (Point2D)o1;
            lat1 = (float)point.getX();
            lon1 = (float)point.getY();
        }
        if (o2 instanceof Cell) {
            cell = (Cell)o2;
            lat2 = cell.getLatitude();
            lon2 = cell.getLongitude();
        } else {
            point = (Point2D)o2;
            lat2 = (float)point.getX();
            lon2 = (float)point.getY();
        }
        int result = Double.compare(lat1, lat2);
        if (result == 0) {
            result = Double.compare(lon1, lon2);
        }
        return result;
    }
}

