/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.widget.editor;

import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.ui.input.equation.EquationEditorPaneUI;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

public class EquationTableEditor
extends JButton
implements TableCellEditor {
    private static final long serialVersionUID = -2483612426979170213L;
    protected Set<CellEditorListener> listeners = new HashSet<CellEditorListener>();
    protected EquationEditorPaneUI frame = null;
    protected Equation equation = null;

    public EquationTableEditor() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EquationEditorPaneUI editorFrame = EquationTableEditor.this.getFrame();
                editorFrame.setLocationByPlatform(true);
                ((Window)editorFrame).setVisible(true);
            }
        });
    }

    protected EquationEditorPaneUI getFrame() {
        if (this.frame == null) {
            this.frame = new EquationEditorPaneUI();
            this.frame.getOkButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EquationTableEditor.this.stopCellEditing();
                }
            });
            this.frame.getCancelButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EquationTableEditor.this.cancelCellEditing();
                }
            });
        }
        return this.frame;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.equation = (Equation)value;
        this.setText(this.equation.getName());
        try {
            this.getFrame().getHandler().setEquation(this.equation.getCategory(), this.equation.getName(), this.equation.getJavaInterface(), this.equation.getContent());
        }
        catch (Exception eee) {
            throw new IsisFishRuntimeException("Can't create file to edit equation", eee);
        }
        return this;
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.listeners.remove(l);
    }

    @Override
    public Object getCellEditorValue() {
        if (this.equation != null) {
            String content = this.getFrame().getEditor().getText();
            this.equation.setContent(content);
        }
        return this.equation;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public void cancelCellEditing() {
        ChangeEvent e = new ChangeEvent(this);
        for (CellEditorListener l : this.listeners) {
            l.editingCanceled(e);
        }
        if (this.frame != null) {
            this.frame.dispose();
        }
    }

    @Override
    public boolean stopCellEditing() {
        ChangeEvent e = new ChangeEvent(this);
        for (CellEditorListener l : this.listeners) {
            l.editingStopped(e);
        }
        if (this.frame != null) {
            this.frame.dispose();
        }
        return true;
    }
}

