/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.simulator;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.ui.WelcomePanelUI;
import fr.ifremer.isisfish.ui.models.common.GenericListModel;
import fr.ifremer.isisfish.ui.simulator.ExportUI;
import fr.ifremer.isisfish.ui.simulator.SimulatorTabHandler;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.ListSelectionEvent;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ExportHandler
extends SimulatorTabHandler {
    private static final Log log = LogFactory.getLog(ExportHandler.class);
    protected ExportUI tabUI;

    protected ExportHandler(ExportUI tabUI) {
        super((JAXXContext)tabUI);
        this.tabUI = tabUI;
    }

    protected void afterInit() {
        this.refresh();
    }

    public void refresh() {
        this.setListSimulExportChooseModel();
    }

    protected void setListSimulExportChooseModel() {
        List<String> paramExports = this.getParameters().getExportNames();
        List<String> availableExports = ExportStorage.getExportNames();
        GenericListModel<String> exportModel = new GenericListModel<String>(availableExports);
        this.tabUI.listSimulExportChoose.setModel(exportModel);
        for (String userExport : paramExports) {
            int index = availableExports.indexOf(userExport);
            this.tabUI.listSimulExportChoose.addSelectionInterval(index, index);
        }
    }

    protected void saveSimulationExports(ListSelectionEvent event) {
        LinkedList<String> exportNames = new LinkedList<String>(this.tabUI.listSimulExportChoose.getSelectedValuesList());
        this.getParameters().setExportNames(exportNames);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Set exports in simulation : " + exportNames));
        }
    }

    protected void saveConfigExports() {
        LinkedList<String> exportNames = new LinkedList<String>(this.tabUI.listSimulExportChoose.getSelectedValuesList());
        IsisFish.config.setDefaultExportNames(exportNames);
        this.setInfoText(I18n.t((String)"isisfish.export.saved", (Object[])new Object[0]));
    }

    protected void setInfoText(String txt) {
        WelcomePanelUI root = this.tabUI.getParentContainer(WelcomePanelUI.class);
        root.setStatusMessage(txt);
    }
}

