/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.result;

import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.datastore.ResultStorage;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.datastore.StorageException;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.export.ExportHelper;
import fr.ifremer.isisfish.logging.SimulationLoggerUtil;
import fr.ifremer.isisfish.simulator.launcher.SimulationJob;
import fr.ifremer.isisfish.simulator.launcher.SimulationService;
import fr.ifremer.isisfish.simulator.launcher.SimulationServiceListener;
import fr.ifremer.isisfish.ui.CommonHandler;
import fr.ifremer.isisfish.ui.models.common.GenericComboModel;
import fr.ifremer.isisfish.ui.result.MatrixMapRenderer;
import fr.ifremer.isisfish.ui.result.MatrixSummaryRenderer;
import fr.ifremer.isisfish.ui.result.ResultMatrixFilter;
import fr.ifremer.isisfish.ui.result.ResultSimulationFrame;
import fr.ifremer.isisfish.ui.result.ResultUI;
import fr.ifremer.isisfish.ui.result.SumByYearMatrixFilter;
import fr.ifremer.isisfish.ui.result.YearSumDimensionAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.viewer.MatrixDimensionAction;
import org.nuiton.math.matrix.viewer.MatrixFilter;
import org.nuiton.math.matrix.viewer.MatrixRenderer;
import org.nuiton.math.matrix.viewer.MatrixViewerPanel;
import org.nuiton.math.matrix.viewer.renderer.MatrixChartRenderer;
import org.nuiton.math.matrix.viewer.renderer.MatrixPanelRenderer;
import org.nuiton.topia.TopiaException;
import org.nuiton.util.FileUtil;

public class ResultHandler
extends CommonHandler {
    private static Log log = LogFactory.getLog(ResultHandler.class);
    protected SimulationServiceListener listener = null;
    protected ResultUI resultUI;

    public ResultHandler(ResultUI resultUI) {
        this.resultUI = resultUI;
    }

    public void afterInit() {
        this.initSimulationList();
        this.listener = new SimulationServiceListener(){

            @Override
            public void simulationStart(SimulationService simService, SimulationJob job) {
            }

            @Override
            public void simulationStop(SimulationService simService, final SimulationJob job) {
                final GenericComboModel model = (GenericComboModel)ResultHandler.this.resultUI.getSimulationComboBox().getModel();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        model.addElement(job.getId());
                    }
                });
            }

            @Override
            public void clearJobDone(SimulationService simService) {
            }
        };
        SimulationService.getService().addSimulationServiceListener(this.listener);
    }

    protected void initSimulationList() {
        List<String> value = SimulationStorage.getSimulationNames();
        GenericComboModel<String> model = new GenericComboModel<String>(value);
        this.resultUI.getSimulationComboBox().setModel(model);
        this.resultUI.getSimulationComboBox().setSelectedItem(null);
    }

    public void openNewSimulation() {
        block2: {
            String selected = (String)this.resultUI.getSimulationComboBox().getSelectedItem();
            SimulationStorage simulation = SimulationStorage.getSimulation(selected);
            ResultSimulationFrame internalFrame = new ResultSimulationFrame((JAXXContext)this.resultUI);
            internalFrame.setTitle(simulation.getName());
            internalFrame.setSimulationStorage(simulation);
            this.init(internalFrame);
            internalFrame.setSize(800, 600);
            this.resultUI.getSimulationDesktopPane().add(internalFrame);
            try {
                internalFrame.setSelected(true);
            }
            catch (PropertyVetoException ex) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)"Can't auto selected internal frame", (Throwable)ex);
            }
        }
    }

    public void deleteSimulation() {
        String selected = (String)this.resultUI.getSimulationComboBox().getSelectedItem();
        SimulationStorage simulation = SimulationStorage.getSimulation(selected);
        try {
            simulation.delete(false);
        }
        catch (StorageException ex) {
            throw new IsisFishRuntimeException("Can't delete simulation", ex);
        }
        this.initSimulationList();
    }

    public void showLog() {
        String selected = (String)this.resultUI.getSimulationComboBox().getSelectedItem();
        try {
            SimulationLoggerUtil.showSimulationLogConsole(this.resultUI, selected);
        }
        catch (Exception ex) {
            throw new IsisFishRuntimeException("Can't display simulation log", ex);
        }
    }

    public void init(final ResultSimulationFrame resultSimulationFrame) {
        SimulationStorage simulation = resultSimulationFrame.getSimulationStorage();
        try {
            for (String exportName : ExportStorage.getExportNames()) {
                JMenuItem item = new JMenuItem(I18n.t((String)exportName, (Object[])new Object[0]));
                item.addActionListener(new ExportActionListener(simulation, exportName));
                resultSimulationFrame.getExportMenu().add(item);
            }
            resultSimulationFrame.topiaContext = simulation.getStorage().beginTransaction();
            final ResultStorage resultStorage = simulation.getResultStorage();
            FisheryRegion fisheryRegion = SimulationStorage.getFisheryRegion(resultSimulationFrame.topiaContext);
            final MatrixViewerPanel matrixViewerPanel = new MatrixViewerPanel();
            matrixViewerPanel.addMatrixDimentionAction((MatrixDimensionAction)new YearSumDimensionAction());
            matrixViewerPanel.addMatrixRenderer((MatrixRenderer)new MatrixSummaryRenderer(simulation, resultStorage, resultSimulationFrame.topiaContext), true);
            matrixViewerPanel.addMatrixRenderer((MatrixRenderer)new MatrixChartRenderer());
            matrixViewerPanel.addMatrixRenderer((MatrixRenderer)new MatrixMapRenderer(fisheryRegion));
            matrixViewerPanel.addMatrixRenderer((MatrixRenderer)new MatrixPanelRenderer());
            matrixViewerPanel.addMatrixFilter((MatrixFilter)new ResultMatrixFilter(resultStorage));
            matrixViewerPanel.addMatrixFilter((MatrixFilter)new SumByYearMatrixFilter());
            GenericComboModel<String> model = new GenericComboModel<String>(resultStorage.getResultName());
            resultSimulationFrame.getResultsComboBox().setModel(model);
            resultSimulationFrame.getResultsComboBox().addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        String selectedMatrixName = (String)e.getItem();
                        MatrixND matrix = resultStorage.getMatrix(selectedMatrixName, resultSimulationFrame.topiaContext);
                        matrixViewerPanel.setMatrix(matrix);
                    }
                }
            });
            matrixViewerPanel.updateSelectedRenderingComponent();
            resultSimulationFrame.getMatrixViewerContainer().add((Component)matrixViewerPanel, "Center");
            if (model.getSize() > 0) {
                model.setSelectedItem(model.getElementAt(0));
            }
        }
        catch (TopiaException ex) {
            throw new IsisFishRuntimeException("Can't open simulation", ex);
        }
        catch (StorageException ex) {
            throw new IsisFishRuntimeException("Can't open simulation", ex);
        }
    }

    protected class ExportActionListener
    implements ActionListener {
        protected SimulationStorage simulationStorage;
        protected String exportName;

        public ExportActionListener(SimulationStorage simulationStorage, String exportName) {
            this.simulationStorage = simulationStorage;
            this.exportName = exportName;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            block4: {
                try {
                    File file = FileUtil.getFile((String[])new String[]{".+\\.csv(\\.gz)?", I18n.t((String)"isisfish.result.export.file", (Object[])new Object[0])});
                    if (file != null) {
                        if (!file.getName().matches(".+\\.csv(\\.gz)?")) {
                            file = new File(file.getAbsolutePath() + ".csv.gz");
                        }
                        ExportHelper.exportToFile(this.simulationStorage, this.exportName, file);
                    }
                }
                catch (Exception eee) {
                    if (!log.isWarnEnabled()) break block4;
                    log.warn((Object)"Erreur lors de l'export ", (Throwable)eee);
                }
            }
        }
    }
}

