/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input.metier;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.MetierSeasonInfo;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.entities.TargetSpecies;
import fr.ifremer.isisfish.entities.TargetSpeciesDAO;
import fr.ifremer.isisfish.ui.input.InputContentHandler;
import fr.ifremer.isisfish.ui.input.metier.MetierSeasonInfoSpeciesUI;
import fr.ifremer.isisfish.ui.input.metier.MetierSeasonInfoTargetSpeciesTableModel;
import fr.ifremer.isisfish.ui.models.common.GenericComboModel;
import fr.ifremer.isisfish.ui.util.ErrorHelper;
import fr.ifremer.isisfish.ui.widget.editor.EquationTableEditor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class MetierSeasonInfoSpeciesHandler
extends InputContentHandler<MetierSeasonInfoSpeciesUI> {
    private static final Log log = LogFactory.getLog(MetierSeasonInfoSpeciesHandler.class);

    protected MetierSeasonInfoSpeciesHandler(MetierSeasonInfoSpeciesUI inputContentUI) {
        super(inputContentUI);
    }

    protected void afterInit() {
        ((MetierSeasonInfoSpeciesUI)this.inputContentUI).addPropertyChangeListener("bean", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MetierSeasonInfoSpeciesHandler.this.setSeasonModel();
                ((MetierSeasonInfoSpeciesUI)MetierSeasonInfoSpeciesHandler.this.inputContentUI).setSpecies(null);
                ((MetierSeasonInfoSpeciesUI)MetierSeasonInfoSpeciesHandler.this.inputContentUI).setMetierSeasonInfo(null);
                MetierSeasonInfoSpeciesHandler.this.setTargetSpeciesModel();
                MetierSeasonInfoSpeciesHandler.this.setTableTargetSpeciesModel();
            }
        });
    }

    protected void setSeasonModel() {
        List<MetierSeasonInfo> metierSeasonInfo = null;
        if (((MetierSeasonInfoSpeciesUI)this.inputContentUI).getBean() != null) {
            metierSeasonInfo = ((MetierSeasonInfoSpeciesUI)this.inputContentUI).getBean().getMetierSeasonInfo();
        }
        GenericComboModel seasonModel = new GenericComboModel(metierSeasonInfo);
        ((MetierSeasonInfoSpeciesUI)this.inputContentUI).fieldMetierSeasonInfo.setModel(seasonModel);
    }

    protected void metierSeasonInfoChanged() {
        MetierSeasonInfo selectedMSI = (MetierSeasonInfo)((MetierSeasonInfoSpeciesUI)this.inputContentUI).fieldMetierSeasonInfo.getSelectedItem();
        ((MetierSeasonInfoSpeciesUI)this.inputContentUI).setMetierSeasonInfo(selectedMSI);
        if (selectedMSI != null) {
            ((MetierSeasonInfoSpeciesUI)this.inputContentUI).getSaveVerifier().addCurrentEntity(((MetierSeasonInfoSpeciesUI)this.inputContentUI).getMetierSeasonInfo());
            this.setTableTargetSpeciesModel();
        }
    }

    protected void setTargetSpeciesModel() {
        List<Species> species = ((MetierSeasonInfoSpeciesUI)this.inputContentUI).getFisheryRegion().getSpecies();
        GenericComboModel<Species> fieldTargetSpeciesModel = new GenericComboModel<Species>(species);
        ((MetierSeasonInfoSpeciesUI)this.inputContentUI).fieldTargetSpecies.setModel(fieldTargetSpeciesModel);
    }

    protected void speciesChanged() {
        Species species = (Species)((MetierSeasonInfoSpeciesUI)this.inputContentUI).fieldTargetSpecies.getSelectedItem();
        ((MetierSeasonInfoSpeciesUI)this.inputContentUI).setSpecies(species);
    }

    protected void setTableTargetSpeciesModel() {
        ArrayList<TargetSpecies> targetSpecies = new ArrayList<TargetSpecies>();
        if (((MetierSeasonInfoSpeciesUI)this.inputContentUI).getBean() != null && ((MetierSeasonInfoSpeciesUI)this.inputContentUI).getMetierSeasonInfo() != null && ((MetierSeasonInfoSpeciesUI)this.inputContentUI).getMetierSeasonInfo().getSpeciesTargetSpecies() != null) {
            for (TargetSpecies oneTargetSpecies : ((MetierSeasonInfoSpeciesUI)this.inputContentUI).getMetierSeasonInfo().getSpeciesTargetSpecies()) {
                targetSpecies.add(oneTargetSpecies);
                ((MetierSeasonInfoSpeciesUI)this.inputContentUI).getSaveVerifier().addCurrentEntity(oneTargetSpecies);
                oneTargetSpecies.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        ((MetierSeasonInfoSpeciesUI)((MetierSeasonInfoSpeciesHandler)MetierSeasonInfoSpeciesHandler.this).inputContentUI).changeModel.setStayChanged(true);
                    }
                });
            }
        }
        MetierSeasonInfoTargetSpeciesTableModel model = new MetierSeasonInfoTargetSpeciesTableModel(targetSpecies);
        ((MetierSeasonInfoSpeciesUI)this.inputContentUI).tableTargetSpecies.setModel(model);
        ((MetierSeasonInfoSpeciesUI)this.inputContentUI).tableTargetSpecies.setDefaultRenderer(Equation.class, model);
        ((MetierSeasonInfoSpeciesUI)this.inputContentUI).tableTargetSpecies.setDefaultEditor(Equation.class, new EquationTableEditor());
    }

    protected void add() {
        Species selectedSpecies = (Species)((MetierSeasonInfoSpeciesUI)this.inputContentUI).fieldTargetSpecies.getSelectedItem();
        if (selectedSpecies != null) {
            this.addTargetSpecies(((MetierSeasonInfoSpeciesUI)this.inputContentUI).getBean(), ((MetierSeasonInfoSpeciesUI)this.inputContentUI).getMetierSeasonInfo(), selectedSpecies, ((MetierSeasonInfoSpeciesUI)this.inputContentUI).targetFactor.getEditor().getText(), ((MetierSeasonInfoSpeciesUI)this.inputContentUI).fieldPrimaryCatch.isSelected());
            this.setTableTargetSpeciesModel();
        }
    }

    protected void remove() {
        Object[] targetSpecies = ((MetierSeasonInfoSpeciesUI)this.inputContentUI).getMetierSeasonInfo().getSpeciesTargetSpecies().toArray();
        Object o = targetSpecies[((MetierSeasonInfoSpeciesUI)this.inputContentUI).tableTargetSpecies.getSelectedRow()];
        if (o != null) {
            TargetSpecies ts = (TargetSpecies)o;
            this.removeTargetSpecies(((MetierSeasonInfoSpeciesUI)this.inputContentUI).getMetierSeasonInfo(), ts);
            ((MetierSeasonInfoSpeciesUI)this.inputContentUI).getSaveVerifier().removeCurrentEntity(ts.getTopiaId());
            this.setTableTargetSpeciesModel();
        }
    }

    public void addTargetSpecies(Metier metier, MetierSeasonInfo m, Species species, String targetFactorEquationContent, boolean primaryCatch) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("addTargetSpecies called: " + metier + " " + species + " " + primaryCatch + " " + targetFactorEquationContent));
        }
        try {
            String targetFactorEquationName = metier.getName() + "-" + species.getName() + "(" + m.getFirstMonth() + "-" + m.getLastMonth() + ")";
            TargetSpeciesDAO dao = IsisFishDAOHelper.getTargetSpeciesDAO(metier.getTopiaContext());
            TargetSpecies targetSpecies = (TargetSpecies)dao.create(new Object[0]);
            targetSpecies.setSpecies(species);
            targetSpecies.getTargetFactorEquation().setName(targetFactorEquationName);
            targetSpecies.getTargetFactorEquation().setContent(targetFactorEquationContent);
            targetSpecies.setPrimaryCatch(primaryCatch);
            m.addSpeciesTargetSpecies(targetSpecies);
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't add TargetSpecies", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.input.addentity", (Object[])new Object[]{"TargetSpecies"}), eee);
        }
    }

    public void removeTargetSpecies(MetierSeasonInfo m, TargetSpecies targetSpecies) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeTargetSpecies called: " + targetSpecies));
        }
        try {
            if (targetSpecies != null) {
                m.removeSpeciesTargetSpecies(targetSpecies);
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't remove TargetSpecies", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.input.removeentity", (Object[])new Object[]{"TargetSpecies"}), eee);
        }
    }
}

