/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.map;

import com.bbn.openmap.Layer;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMRect;
import com.bbn.openmap.proj.Projection;
import fr.ifremer.isisfish.entities.Cell;
import fr.ifremer.isisfish.entities.FisheryRegion;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Paint;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.event.TopiaTransactionEvent;
import org.nuiton.topia.event.TopiaTransactionListener;
import org.nuiton.topia.persistence.TopiaEntity;

public class ZoneDelimiterLayer
extends Layer
implements TopiaTransactionListener {
    private static final long serialVersionUID = 1127201121371123690L;
    private static Log log = LogFactory.getLog(ZoneDelimiterLayer.class);
    protected Projection proj = null;
    protected OMGraphicList graphics = new OMGraphicList();
    protected float pasMailleLatitude;
    protected float pasMailleLongitude;
    protected FisheryRegion fisheryRegion;
    protected Collection<Cell> cells;

    public ZoneDelimiterLayer(FisheryRegion fisheryRegion) throws TopiaException {
        this.fisheryRegion = fisheryRegion;
        this.pasMailleLatitude = fisheryRegion.getCellLengthLatitude();
        this.pasMailleLongitude = fisheryRegion.getCellLengthLongitude();
        this.cells = fisheryRegion.getCell();
        TopiaContext topiaContext = fisheryRegion.getTopiaContext();
        topiaContext.addTopiaTransactionListener((TopiaTransactionListener)this);
        this.setVisible(true);
        this.generateGraphics();
    }

    public void setProjection(Projection proj) {
        this.proj = proj;
    }

    public Projection getProjection() {
        return this.proj;
    }

    public void renderDataForProjection(Projection proj, Graphics g) {
        if (proj == null) {
            return;
        }
        this.setProjection(proj.makeClone());
        this.paint(g);
    }

    public void projectionChanged(ProjectionEvent e) {
        this.setProjection(e.getProjection());
        this.repaint();
    }

    protected void generateGraphics() throws TopiaException {
        this.graphics.clear();
        for (Cell cell : this.cells) {
            OMRect omrect = new OMRect((double)(cell.getLatitude() + this.pasMailleLatitude), (double)cell.getLongitude(), (double)cell.getLatitude(), (double)(cell.getLongitude() + this.pasMailleLongitude), 1);
            if (cell.isLand()) {
                omrect.setLinePaint((Paint)new Color(Color.red.getRed(), Color.red.getGreen(), Color.red.getBlue(), 0));
            } else {
                omrect.setLinePaint((Paint)Color.red);
            }
            omrect.setVisible(true);
            this.graphics.add((OMGraphic)omrect);
        }
        this.graphics.generate(this.getProjection());
    }

    protected void refresh() {
        block2: {
            try {
                this.cells = this.fisheryRegion.getCell();
                this.generateGraphics();
                this.repaint();
            }
            catch (TopiaException eee) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)"Can't refresh view", (Throwable)eee);
            }
        }
    }

    public void paint(Graphics g) {
        this.graphics.generate(this.getProjection());
        this.graphics.render(g);
    }

    public void commit(TopiaTransactionEvent event) {
        for (TopiaEntity e : event.getEntities()) {
            if (!event.isModification(e) || !Cell.class.isAssignableFrom(e.getClass())) continue;
            this.refresh();
            break;
        }
    }

    public void rollback(TopiaTransactionEvent event) {
    }
}

