/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.EquationDAO;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.PopulationSeasonInfoAbstract;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.equation.EmigrationEquation;
import fr.ifremer.isisfish.equation.ImmigrationEquation;
import fr.ifremer.isisfish.equation.MigrationEquation;
import fr.ifremer.isisfish.types.Month;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixHelper;
import org.nuiton.math.matrix.MatrixIterator;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaException;

public class PopulationSeasonInfoImpl
extends PopulationSeasonInfoAbstract {
    private static final long serialVersionUID = 1375563617129149755L;
    private static Log log = LogFactory.getLog(PopulationSeasonInfoImpl.class);

    public PopulationSeasonInfoImpl() {
        this.setSimpleLengthChangeMatrix(true);
    }

    @Override
    public MatrixND getReproductionDistribution() {
        List<Month> months;
        MatrixND result = super.getReproductionDistribution();
        List oldMonths = null;
        if (result != null) {
            oldMonths = result.getSemantic(0);
        }
        if (!(months = this.getMonths()).equals(oldMonths)) {
            MatrixND tmp = MatrixFactory.getInstance().create(I18n.n((String)"isisfish.populationSeasonInfo.distributionSpawing", (Object[])new Object[0]), new List[]{months}, new String[]{I18n.n((String)"isisfish.populationSeasonInfo.months", (Object[])new Object[0])});
            tmp.pasteSemantics(result);
            result = tmp;
        }
        return result;
    }

    @Override
    public MatrixND getMigrationMatrix() {
        MatrixND mat = super.getMigrationMatrix();
        if (this.getPopulation() != null) {
            List<PopulationGroup> groups = this.getPopulation().getPopulationGroup();
            List<Zone> zones = this.getPopulation().getPopulationZone();
            Object[] sems = new List[]{groups, zones, zones};
            if (mat == null) {
                mat = MatrixFactory.getInstance().create(I18n.n((String)"isisfish.populationSeasonInfo.migration", (Object[])new Object[0]), (List[])sems, new String[]{I18n.n((String)"isisfish.populationSeasonInfo.group", (Object[])new Object[0]), I18n.n((String)"isisfish.populationSeasonInfo.departure", (Object[])new Object[0]), I18n.n((String)"isisfish.populationSeasonInfo.arrival", (Object[])new Object[0])});
            } else if (!Arrays.equals(mat.getSemantics(), sems)) {
                MatrixND newmat = MatrixFactory.getInstance().create(I18n.n((String)"isisfish.populationSeasonInfo.migration", (Object[])new Object[0]), (List[])sems, new String[]{I18n.n((String)"isisfish.populationSeasonInfo.group", (Object[])new Object[0]), I18n.n((String)"isisfish.populationSeasonInfo.departure", (Object[])new Object[0]), I18n.n((String)"isisfish.populationSeasonInfo.arrival", (Object[])new Object[0])});
                newmat.pasteSemantics(mat);
                mat = newmat;
            }
        }
        return mat;
    }

    @Override
    public MatrixND getEmigrationMatrix() {
        MatrixND mat = super.getEmigrationMatrix();
        if (this.getPopulation() != null) {
            List<PopulationGroup> groups = this.getPopulation().getPopulationGroup();
            List<Zone> zones = this.getPopulation().getPopulationZone();
            Object[] sems = new List[]{groups, zones};
            if (mat == null) {
                mat = MatrixFactory.getInstance().create(I18n.n((String)"isisfish.populationSeasonInfo.emigration", (Object[])new Object[0]), (List[])sems, new String[]{I18n.n((String)"isisfish.populationSeasonInfo.group", (Object[])new Object[0]), I18n.n((String)"isisfish.populationSeasonInfo.departure", (Object[])new Object[0])});
            } else if (!Arrays.equals(mat.getSemantics(), sems)) {
                MatrixND newmat = MatrixFactory.getInstance().create(I18n.n((String)"isisfish.populationSeasonInfo.emigration", (Object[])new Object[0]), (List[])sems, new String[]{I18n.n((String)"isisfish.populationSeasonInfo.group", (Object[])new Object[0]), I18n.n((String)"isisfish.populationSeasonInfo.departure", (Object[])new Object[0])});
                newmat.pasteSemantics(mat);
                mat = newmat;
            }
        }
        return mat;
    }

    @Override
    public MatrixND getImmigrationMatrix() {
        MatrixND mat = super.getImmigrationMatrix();
        if (this.getPopulation() != null) {
            List<PopulationGroup> groups = this.getPopulation().getPopulationGroup();
            List<Zone> zones = this.getPopulation().getPopulationZone();
            Object[] sems = new List[]{groups, zones};
            if (mat == null) {
                mat = MatrixFactory.getInstance().create(I18n.n((String)"isisfish.populationSeasonInfo.immigration", (Object[])new Object[0]), (List[])sems, new String[]{I18n.n((String)"isisfish.populationSeasonInfo.group", (Object[])new Object[0]), I18n.n((String)"isisfish.populationSeasonInfo.arrival", (Object[])new Object[0])});
            } else if (!Arrays.equals(mat.getSemantics(), sems)) {
                MatrixND newmat = MatrixFactory.getInstance().create(I18n.n((String)"isisfish.populationSeasonInfo.immigration", (Object[])new Object[0]), (List[])sems, new String[]{I18n.n((String)"isisfish.populationSeasonInfo.group", (Object[])new Object[0]), I18n.n((String)"isisfish.populationSeasonInfo.arrival", (Object[])new Object[0])});
                newmat.pasteSemantics(mat);
                mat = newmat;
            }
        }
        return mat;
    }

    @Override
    public double getCapturability(PopulationGroup group) {
        double result = 0.0;
        if (this.getPopulation() != null) {
            MatrixND captu = this.getPopulation().getCapturability();
            result = captu.getValue((Object)group, (Object)this);
        }
        return result;
    }

    public MatrixND createNoSpacializedChangeGroupMatrix() {
        Population pop = this.getPopulation();
        List<PopulationGroup> groups = pop.getPopulationGroup();
        MatrixND result = MatrixFactory.getInstance().create(new List[]{groups, groups});
        return result;
    }

    @Override
    public MatrixND getLengthChangeMatrix() {
        MatrixND matrix = super.getLengthChangeMatrix();
        if (matrix == null && this.getPopulation() != null) {
            matrix = this.createNoSpacializedChangeGroupMatrix();
        }
        return matrix;
    }

    @Override
    public MatrixND unspacializeLengthChangeMatrix(MatrixND mat) {
        Population pop = this.getPopulation();
        int nbsecteurs = pop.sizePopulationZone();
        int nbclasses = pop.sizePopulationGroup();
        MatrixND smallmat = this.createNoSpacializedChangeGroupMatrix();
        for (int i = 0; i < nbclasses; ++i) {
            for (int j = 0; j < nbclasses; ++j) {
                double val = mat.getValue(i * nbsecteurs, j * nbsecteurs);
                smallmat.setValue(i, j, val);
            }
        }
        return smallmat;
    }

    protected MatrixND createSpacializedChangeGroupMatrix() {
        Population pop = this.getPopulation();
        List<Zone> zones = pop.getPopulationZone();
        List<PopulationGroup> groups = pop.getPopulationGroup();
        ArrayList<String> semantique = new ArrayList<String>();
        for (PopulationGroup group : groups) {
            for (Zone zone : zones) {
                semantique.add(group + "/" + zone);
            }
        }
        MatrixND result = MatrixFactory.getInstance().create(new List[]{semantique, semantique});
        return result;
    }

    @Override
    public MatrixND spacializeLengthChangeMatrix(MatrixND mat) {
        Population pop = this.getPopulation();
        int nbsecteurs = pop.sizePopulationZone();
        int nbclasses = pop.sizePopulationGroup();
        MatrixND bigmat = this.createSpacializedChangeGroupMatrix();
        for (int i = 0; i < nbclasses; ++i) {
            for (int j = 0; j < nbclasses; ++j) {
                MatrixND matId = MatrixFactory.getInstance().matrixId(nbsecteurs);
                matId.mults(mat.getValue(i, j));
                bigmat.paste(new int[]{i * nbsecteurs, j * nbsecteurs}, matId);
            }
        }
        return bigmat;
    }

    @Override
    public MatrixND computeLengthChangeMatrix() {
        int NB_DISCRETISATION = 10;
        Population pop = this.getPopulation();
        List<PopulationGroup> groups = pop.getPopulationGroup();
        MatrixND result = this.createNoSpacializedChangeGroupMatrix();
        for (int i = 0; i < groups.size(); ++i) {
            int l;
            PopulationGroup group = groups.get(i);
            double min = group.getMinLength();
            double max = group.getMaxLength();
            double step = (max - min) / (double)NB_DISCRETISATION;
            double[] length = new double[NB_DISCRETISATION];
            length[0] = min;
            for (l = 1; l < NB_DISCRETISATION; ++l) {
                length[l] = length[l - 1] + step;
            }
            for (l = 0; l < NB_DISCRETISATION; ++l) {
                double age = pop.getAge(length[l], group);
                length[l] = pop.getLength(age + 1.0, group);
            }
            for (l = 0; l < NB_DISCRETISATION; ++l) {
                int c;
                for (c = 0; c < groups.size() && !groups.get(c).isInLength(length[l]); ++c) {
                }
                if (c >= groups.size()) {
                    log.warn((Object)(I18n.t((String)"isisfish.error.acceptable.population", (Object[])new Object[0]) + " (group=" + group + " new length: " + length[l] + ")"));
                    result.setValue(i, i, result.getValue(i, i) + 1.0);
                    continue;
                }
                result.setValue(i, c, result.getValue(i, c) + 1.0);
            }
        }
        result = result.divs((double)NB_DISCRETISATION);
        return result;
    }

    @Override
    public MatrixND getGroupChangeMatrix(Month month) {
        Population pop = this.getPopulation();
        if (log.isDebugEnabled()) {
            log.debug((Object)("pop: " + pop + " AgeGroup: " + pop.getSpecies().isAgeGroupType() + " groupChange: " + this.isGroupChange() + " month: " + month + " firstMonth: " + this.getFirstMonth()));
        }
        if (!pop.getSpecies().isAgeGroupType()) {
            if (this.isSimpleLengthChangeMatrix()) {
                return this.spacializeLengthChangeMatrix(this.getLengthChangeMatrix());
            }
            return this.getLengthChangeMatrix();
        }
        if (this.isGroupChange() && month.getMonthNumber() == this.getFirstMonth().getMonthNumber()) {
            int nbrAge = pop.sizePopulationGroup();
            int nbrZone = pop.sizePopulationZone();
            boolean groupplus = pop.isPlusGroup();
            MatrixND result = this.createSpacializedChangeGroupMatrix();
            MatrixIterator mi = result.iterator();
            while (mi.next()) {
                int j;
                int[] dim = mi.getCoordinates();
                int i = dim[0];
                if (i + nbrZone != (j = dim[1]) && (!groupplus || nbrAge - 1 != i / nbrZone || i != j)) continue;
                mi.setValue(1.0);
            }
            return result;
        }
        int nbsecteurs = pop.sizePopulationZone();
        int nbclasses = pop.sizePopulationGroup();
        int dim = nbsecteurs * nbclasses;
        return MatrixFactory.getInstance().matrixId(dim);
    }

    @Override
    public MatrixND getMigrationMatrix(Month month, MatrixND N) {
        if (month.getMonthNumber() == this.getFirstMonth().getMonthNumber()) {
            return this.getMigrationMatrix(N);
        }
        MatrixND result = this.createSpacializedChangeGroupMatrix();
        MatrixHelper.convertToId((MatrixND)result);
        return result;
    }

    protected MatrixND getMigrationMatrix(MatrixND aN) {
        MatrixND mat = null;
        try {
            Population population = this.getPopulation();
            List<Zone> zones = population.getPopulationZone();
            List<PopulationGroup> groups = population.getPopulationGroup();
            int nbSecteur = zones.size();
            mat = this.createSpacializedChangeGroupMatrix();
            MatrixHelper.convertToId((MatrixND)mat);
            if (this.isUseEquationMigration()) {
                MatrixND N = MatrixFactory.getInstance().create(aN);
                Equation eq = this.getMigrationEquation();
                for (int c = 0; c < groups.size(); ++c) {
                    PopulationGroup group = groups.get(c);
                    for (int d = 0; d < zones.size(); ++d) {
                        Zone departureZone = zones.get(d);
                        for (int a = 0; a < zones.size(); ++a) {
                            Zone arrivalZone = zones.get(a);
                            if (departureZone.equals(arrivalZone)) continue;
                            double coef = eq.evaluate("N", N, "pop", population, "group", group, "departureZone", departureZone, "arrivalZone", arrivalZone);
                            int x = c * nbSecteur + d;
                            int y = c * nbSecteur + a;
                            double ancienneVal = mat.getValue(x, x) - coef;
                            mat.setValue(x, x, ancienneVal);
                            if (ancienneVal < 0.0) {
                                log.warn((Object)"Erreur dans la migration, un coef est negatif");
                            }
                            mat.setValue(x, y, coef);
                        }
                    }
                }
            } else {
                MatrixND mig = this.getMigrationMatrix();
                MatrixIterator i = mig.iterator();
                while (i.hasNext()) {
                    i.next();
                    double coef = i.getValue();
                    if (coef == 0.0) continue;
                    int[] coord = i.getCoordinates();
                    int posClasse = coord[0];
                    int posSecteurD = coord[1];
                    int posSecteurA = coord[2];
                    int x = posClasse * nbSecteur + posSecteurD;
                    int y = posClasse * nbSecteur + posSecteurA;
                    double ancienneVal = mat.getValue(x, x);
                    mat.setValue(x, x, ancienneVal - coef);
                    if (ancienneVal < 0.0) {
                        // empty if block
                    }
                    mat.setValue(x, y, coef);
                }
            }
        }
        catch (Exception eee) {
            log.warn((Object)"Erreur lors de la creation de la matrice de migration", (Throwable)eee);
        }
        return mat;
    }

    @Override
    public MatrixND getEmigrationMatrix(Month month, MatrixND N) {
        if (month.getMonthNumber() == this.getFirstMonth().getMonthNumber()) {
            return this.getEmigrationMatrix(N);
        }
        MatrixND result = this.createSpacializedChangeGroupMatrix();
        return result;
    }

    protected MatrixND getEmigrationMatrix(MatrixND aN) {
        MatrixND mat = null;
        try {
            Population population = this.getPopulation();
            List<Zone> zones = population.getPopulationZone();
            List<PopulationGroup> groups = population.getPopulationGroup();
            int nbSecteur = zones.size();
            mat = this.createSpacializedChangeGroupMatrix();
            if (this.isUseEquationMigration()) {
                MatrixND N = MatrixFactory.getInstance().create(aN);
                Equation eq = this.getEmigrationEquation();
                for (int c = 0; c < groups.size(); ++c) {
                    PopulationGroup group = groups.get(c);
                    for (int d = 0; d < zones.size(); ++d) {
                        Zone departureZone = zones.get(d);
                        double coef = eq.evaluate("N", N, "pop", population, "group", group, "departureZone", departureZone);
                        int x = c * nbSecteur + d;
                        mat.setValue(x, x, coef);
                    }
                }
            } else {
                MatrixND mig = this.getEmigrationMatrix();
                MatrixIterator i = mig.iterator();
                while (i.hasNext()) {
                    i.next();
                    double coef = i.getValue();
                    if (coef == 0.0) continue;
                    int[] coord = i.getCoordinates();
                    int posClasse = coord[0];
                    int posSecteurD = coord[1];
                    int x = posClasse * nbSecteur + posSecteurD;
                    mat.setValue(x, x, coef);
                }
            }
        }
        catch (Exception eee) {
            log.warn((Object)"Erreur lors de la creation de la matrice d'emigration", (Throwable)eee);
        }
        return mat;
    }

    @Override
    public MatrixND getImmigrationMatrix(Month month, MatrixND N) {
        if (month.getMonthNumber() == this.getFirstMonth().getMonthNumber()) {
            return this.getImmigrationMatrix(N);
        }
        MatrixND result = this.createSpacializedChangeGroupMatrix();
        return result;
    }

    protected MatrixND getImmigrationMatrix(MatrixND aN) {
        MatrixND mat = null;
        try {
            Population population = this.getPopulation();
            List<Zone> zones = population.getPopulationZone();
            List<PopulationGroup> groups = population.getPopulationGroup();
            int nbSecteur = zones.size();
            mat = MatrixFactory.getInstance().create(new int[]{groups.size() * nbSecteur});
            if (this.isUseEquationMigration()) {
                MatrixND N = MatrixFactory.getInstance().create(aN);
                Equation eq = this.getImmigrationEquation();
                for (int c = 0; c < groups.size(); ++c) {
                    PopulationGroup group = groups.get(c);
                    for (int a = 0; a < zones.size(); ++a) {
                        Zone arrivalZone = zones.get(a);
                        double coef = eq.evaluate("N", N, "pop", population, "group", group, "arrivalZone", arrivalZone);
                        int y = c * nbSecteur + a;
                        mat.setValue(y, coef);
                    }
                }
            } else {
                MatrixND mig = this.getImmigrationMatrix();
                MatrixIterator i = mig.iterator();
                while (i.hasNext()) {
                    i.next();
                    double coef = i.getValue();
                    if (coef == 0.0) continue;
                    int[] coord = i.getCoordinates();
                    int posClasse = coord[0];
                    int posSecteurA = coord[1];
                    int y = posClasse * nbSecteur + posSecteurA;
                    mat.setValue(y, coef);
                }
            }
        }
        catch (Exception eee) {
            log.warn((Object)"Erreur lors de la creation de la matrice d'immigration", (Throwable)eee);
        }
        return mat;
    }

    public void setMigrationEquationContent(String content) {
        try {
            Equation eq = this.getMigrationEquation();
            if (eq == null) {
                EquationDAO dao = IsisFishDAOHelper.getEquationDAO(this.getTopiaContext());
                eq = (Equation)dao.create(new Object[0]);
                eq.setCategory("Migration");
                eq.setLanguage("java");
                eq.setJavaInterface(MigrationEquation.class);
                this.setMigrationEquation(eq);
            }
            if (this.getPopulation() != null) {
                eq.setName(this.getPopulation().getName() + "(" + this.toString() + ")");
            }
            String _oldValue = eq.getContent();
            this.fireOnPreWrite("content", _oldValue, content);
            eq.setContent(content);
            eq.update();
            this.fireOnPostWrite("content", _oldValue, content);
        }
        catch (TopiaException eee) {
            throw new IsisFishRuntimeException(I18n.t((String)"isisfish.error.change.equation", (Object[])new Object[0]), eee);
        }
    }

    public void setEmigrationEquationContent(String content) {
        try {
            Equation eq = this.getEmigrationEquation();
            if (eq == null) {
                EquationDAO dao = IsisFishDAOHelper.getEquationDAO(this.getTopiaContext());
                eq = (Equation)dao.create(new Object[0]);
                eq.setCategory("Emigration");
                eq.setLanguage("java");
                eq.setJavaInterface(EmigrationEquation.class);
                this.setEmigrationEquation(eq);
            }
            if (this.getPopulation() != null) {
                eq.setName(this.getPopulation().getName() + "(" + this.toString() + ")");
            }
            String _oldValue = eq.getContent();
            this.fireOnPreWrite("content", _oldValue, content);
            eq.setContent(content);
            eq.update();
            this.fireOnPostWrite("content", _oldValue, content);
        }
        catch (TopiaException eee) {
            throw new IsisFishRuntimeException(I18n.t((String)"isisfish.error.change.equation", (Object[])new Object[0]), eee);
        }
    }

    public void setImmigrationEquationContent(String content) {
        try {
            Equation eq = this.getImmigrationEquation();
            if (eq == null) {
                EquationDAO dao = IsisFishDAOHelper.getEquationDAO(this.getTopiaContext());
                eq = (Equation)dao.create(new Object[0]);
                eq.setCategory("Immigration");
                eq.setLanguage("java");
                eq.setJavaInterface(ImmigrationEquation.class);
                this.setImmigrationEquation(eq);
            }
            if (this.getPopulation() != null) {
                eq.setName(this.getPopulation().getName() + "(" + this.toString() + ")");
            }
            String _oldValue = eq.getContent();
            this.fireOnPreWrite("content", _oldValue, content);
            eq.setContent(content);
            eq.update();
            this.fireOnPostWrite("content", _oldValue, content);
        }
        catch (TopiaException eee) {
            throw new IsisFishRuntimeException(I18n.t((String)"isisfish.error.change.equation", (Object[])new Object[0]), eee);
        }
    }

    @Override
    public MatrixND getReproductionMatrix(Month month, MatrixND aN) {
        Population pop = this.getPopulation();
        List<Zone> zoneRepro = pop.getReproductionZone();
        MatrixND result = MatrixFactory.getInstance().create(new List[]{zoneRepro});
        try {
            MatrixND N = aN.copy();
            if (this.isReproduction()) {
                Equation e = pop.getReproductionEquation();
                MatrixND coeff = this.getReproductionDistribution().copy();
                e.evaluate("N", N, "pop", pop, "month", month, "prepro", coeff.getValue((Object)month), "zoneRepro", zoneRepro, "groups", N.getSemantic(0), "zones", N.getSemantic(1), "result", result);
            }
        }
        catch (Exception eee) {
            log.fatal((Object)"Error in matrix reproduction creation", (Throwable)eee);
        }
        return result;
    }

    @Override
    public String toString() {
        String result = I18n.t((String)"isisfish.populationSeasonInfo.toString", (Object[])new Object[]{this.getPopulation(), this.getFirstMonth(), this.getLastMonth()});
        return result;
    }
}

