/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.MetierSeasonInfo;
import fr.ifremer.isisfish.entities.SeasonImpl;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.entities.TargetSpecies;
import fr.ifremer.isisfish.entities.Zone;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class MetierSeasonInfoAbstract
extends SeasonImpl
implements MetierSeasonInfo {
    protected String seasonZoneComment;
    protected String comment;
    protected Collection<TargetSpecies> speciesTargetSpecies;
    protected Metier metier;
    protected Collection<Zone> zone;
    private static final long serialVersionUID = 4063482033020822118L;

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)this.getTopiaContext()).getDAO(MetierSeasonInfo.class).update((TopiaEntity)this);
    }

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)this.getTopiaContext()).getDAO(MetierSeasonInfo.class).delete((TopiaEntity)this);
    }

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start((TopiaEntity)this);
        this.accept0(visitor);
        visitor.end((TopiaEntity)this);
    }

    @Override
    protected void accept0(EntityVisitor visitor) throws TopiaException {
        super.accept0(visitor);
        visitor.visit((TopiaEntity)this, "seasonZoneComment", String.class, (Object)this.seasonZoneComment);
        visitor.visit((TopiaEntity)this, "comment", String.class, (Object)this.comment);
        visitor.visit((TopiaEntity)this, "speciesTargetSpecies", Collection.class, TargetSpecies.class, this.speciesTargetSpecies);
        visitor.visit((TopiaEntity)this, "metier", Metier.class, (Object)this.metier);
        visitor.visit((TopiaEntity)this, "zone", Collection.class, Zone.class, this.zone);
    }

    @Override
    public void setSeasonZoneComment(String seasonZoneComment) {
        String oldValue = this.seasonZoneComment;
        this.fireOnPreWrite("seasonZoneComment", oldValue, seasonZoneComment);
        this.seasonZoneComment = seasonZoneComment;
        this.fireOnPostWrite("seasonZoneComment", oldValue, seasonZoneComment);
    }

    @Override
    public String getSeasonZoneComment() {
        String result = this.seasonZoneComment;
        return result;
    }

    @Override
    public void setComment(String comment) {
        String oldValue = this.comment;
        this.fireOnPreWrite("comment", oldValue, comment);
        this.comment = comment;
        this.fireOnPostWrite("comment", oldValue, comment);
    }

    @Override
    public String getComment() {
        String result = this.comment;
        return result;
    }

    @Override
    public void addSpeciesTargetSpecies(TargetSpecies speciesTargetSpecies) {
        this.fireOnPreWrite("speciesTargetSpecies", null, speciesTargetSpecies);
        if (this.speciesTargetSpecies == null) {
            this.speciesTargetSpecies = new ArrayList<TargetSpecies>();
        }
        this.speciesTargetSpecies.add(speciesTargetSpecies);
        this.fireOnPostWrite("speciesTargetSpecies", this.speciesTargetSpecies.size(), null, speciesTargetSpecies);
    }

    @Override
    public void addAllSpeciesTargetSpecies(Collection<TargetSpecies> speciesTargetSpecies) {
        if (speciesTargetSpecies == null) {
            return;
        }
        for (TargetSpecies item : speciesTargetSpecies) {
            this.addSpeciesTargetSpecies(item);
        }
    }

    @Override
    public void setSpeciesTargetSpecies(Collection<TargetSpecies> speciesTargetSpecies) {
        ArrayList<TargetSpecies> oldValue = this.speciesTargetSpecies != null ? new ArrayList<TargetSpecies>(this.speciesTargetSpecies) : null;
        this.fireOnPreWrite("speciesTargetSpecies", oldValue, speciesTargetSpecies);
        this.speciesTargetSpecies = speciesTargetSpecies;
        this.fireOnPostWrite("speciesTargetSpecies", oldValue, speciesTargetSpecies);
    }

    @Override
    public void removeSpeciesTargetSpecies(TargetSpecies speciesTargetSpecies) {
        this.fireOnPreWrite("speciesTargetSpecies", speciesTargetSpecies, null);
        if (this.speciesTargetSpecies == null || !this.speciesTargetSpecies.remove(speciesTargetSpecies)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        this.fireOnPostWrite("speciesTargetSpecies", this.speciesTargetSpecies.size() + 1, speciesTargetSpecies, null);
    }

    @Override
    public void clearSpeciesTargetSpecies() {
        if (this.speciesTargetSpecies == null) {
            return;
        }
        ArrayList<TargetSpecies> oldValue = new ArrayList<TargetSpecies>(this.speciesTargetSpecies);
        this.fireOnPreWrite("speciesTargetSpecies", oldValue, this.speciesTargetSpecies);
        this.speciesTargetSpecies.clear();
        this.fireOnPostWrite("speciesTargetSpecies", oldValue, this.speciesTargetSpecies);
    }

    @Override
    public Collection<TargetSpecies> getSpeciesTargetSpecies() {
        return this.speciesTargetSpecies;
    }

    @Override
    public TargetSpecies getSpeciesTargetSpeciesByTopiaId(String topiaId) {
        return (TargetSpecies)TopiaEntityHelper.getEntityByTopiaId(this.speciesTargetSpecies, (String)topiaId);
    }

    @Override
    public TargetSpecies getSpeciesTargetSpecies(Species species) {
        if (species == null || this.speciesTargetSpecies == null) {
            return null;
        }
        for (TargetSpecies item : this.speciesTargetSpecies) {
            if (!species.equals(item.getSpecies())) continue;
            return item;
        }
        return null;
    }

    @Override
    public int sizeSpeciesTargetSpecies() {
        if (this.speciesTargetSpecies == null) {
            return 0;
        }
        return this.speciesTargetSpecies.size();
    }

    @Override
    public boolean isSpeciesTargetSpeciesEmpty() {
        int size = this.sizeSpeciesTargetSpecies();
        return size == 0;
    }

    @Override
    public void setMetier(Metier metier) {
        Metier oldValue = this.metier;
        this.fireOnPreWrite("metier", oldValue, metier);
        this.metier = metier;
        this.fireOnPostWrite("metier", oldValue, metier);
    }

    @Override
    public Metier getMetier() {
        Metier result = this.metier;
        return result;
    }

    @Override
    public void addZone(Zone zone) {
        this.fireOnPreWrite("zone", null, zone);
        if (this.zone == null) {
            this.zone = new ArrayList<Zone>();
        }
        this.zone.add(zone);
        this.fireOnPostWrite("zone", this.zone.size(), null, zone);
    }

    @Override
    public void addAllZone(Collection<Zone> zone) {
        if (zone == null) {
            return;
        }
        for (Zone item : zone) {
            this.addZone(item);
        }
    }

    @Override
    public void setZone(Collection<Zone> zone) {
        ArrayList<Zone> oldValue = this.zone != null ? new ArrayList<Zone>(this.zone) : null;
        this.fireOnPreWrite("zone", oldValue, zone);
        this.zone = zone;
        this.fireOnPostWrite("zone", oldValue, zone);
    }

    @Override
    public void removeZone(Zone zone) {
        this.fireOnPreWrite("zone", zone, null);
        if (this.zone == null || !this.zone.remove(zone)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        this.fireOnPostWrite("zone", this.zone.size() + 1, zone, null);
    }

    @Override
    public void clearZone() {
        if (this.zone == null) {
            return;
        }
        ArrayList<Zone> oldValue = new ArrayList<Zone>(this.zone);
        this.fireOnPreWrite("zone", oldValue, this.zone);
        this.zone.clear();
        this.fireOnPostWrite("zone", oldValue, this.zone);
    }

    @Override
    public Collection<Zone> getZone() {
        return this.zone;
    }

    @Override
    public Zone getZoneByTopiaId(String topiaId) {
        return (Zone)TopiaEntityHelper.getEntityByTopiaId(this.zone, (String)topiaId);
    }

    @Override
    public int sizeZone() {
        if (this.zone == null) {
            return 0;
        }
        return this.zone.size();
    }

    @Override
    public boolean isZoneEmpty() {
        int size = this.sizeZone();
        return size == 0;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        ArrayList tmp = new ArrayList();
        TopiaDAO dao = ((TopiaContextImplementor)this.getTopiaContext()).getDAO(TargetSpecies.class);
        List findAllByProperties = dao.findAllByProperties("metierSeasonInfo", (Object)this, new Object[0]);
        if (findAllByProperties != null) {
            tmp.addAll(findAllByProperties);
        }
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity == null) continue;
            result.add(entity);
            result.addAll(entity.getComposite());
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder((Object)this).append("seasonZoneComment", (Object)this.seasonZoneComment).append("comment", (Object)this.comment).append("zone", this.zone).toString();
        return result;
    }
}

