/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.JavaSourceStorage;
import fr.ifremer.isisfish.vcs.VCSException;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.ReferenceMap;

public class ScriptStorage
extends JavaSourceStorage {
    public static final String SCRIPT_PATH = "scripts";
    public static final String SCRIPT_TEMPLATE = "templates/script/script.ftl";
    protected static Map<String, ScriptStorage> scriptsCache = new ReferenceMap();

    protected ScriptStorage(File rootSrc, File directory, String name) {
        super(rootSrc, directory, name);
    }

    @Override
    public String getPackage() {
        return SCRIPT_PATH;
    }

    public static File getScriptDirectory() {
        File result = new File(ScriptStorage.getContextDatabaseDirectory(), SCRIPT_PATH);
        result.mkdirs();
        return result;
    }

    public static File getCommunityScriptDirectory() {
        File result = new File(ScriptStorage.getCommunityDatabaseDirectory(), SCRIPT_PATH);
        result.mkdirs();
        return result;
    }

    public static ScriptStorage getScript(String name, CodeSourceStorage.Location ... location) {
        ScriptStorage result = scriptsCache.get(name);
        if (result == null) {
            CodeSourceStorage.Location[] locs = ScriptStorage.nonEmptyLocation(location);
            for (int i = 0; i < locs.length && result == null; ++i) {
                CodeSourceStorage.Location loc = locs[i];
                for (File dir : loc.getDirectories()) {
                    ScriptStorage storage = new ScriptStorage(dir, new File(dir, SCRIPT_PATH), name);
                    if (!storage.getFile().isFile()) continue;
                    result = storage;
                    scriptsCache.put(name, result);
                }
            }
        }
        return result;
    }

    public static ScriptStorage createScript(String name, CodeSourceStorage.Location location) {
        File dir = location.getDirectories()[0];
        ScriptStorage storage = new ScriptStorage(dir, new File(dir, SCRIPT_PATH), name);
        return storage;
    }

    public static void checkout() throws VCSException {
        ScriptStorage.checkout(IsisFish.config.getDatabaseDirectory(), SCRIPT_PATH);
    }

    public static List<String> getScriptNames() {
        File dir = ScriptStorage.getScriptDirectory();
        return ScriptStorage.getStorageNames(dir);
    }

    public static List<String> getNewScriptNames() {
        List<String> result = ScriptStorage.getScriptNames();
        result.removeAll(ScriptStorage.getRemoteScriptNames());
        return result;
    }

    public static List<String> getRemoteScriptNames() {
        File dir = ScriptStorage.getScriptDirectory();
        return ScriptStorage.getRemoteStorageNames(dir);
    }

    public static List<String> getNewRemoteScriptNames() {
        List<String> result = ScriptStorage.getRemoteScriptNames();
        result.removeAll(ScriptStorage.getScriptNames());
        return result;
    }
}

