/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.JavaSourceStorage;
import fr.ifremer.isisfish.vcs.VCSException;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OptimizationStorage
extends JavaSourceStorage {
    private static Log log = LogFactory.getLog(OptimizationStorage.class);
    public static final String OPTIMIZATION_PATH = "optimizations";
    public static final String OPTIMIZATION_TEMPLATE = "templates/script/optimization.ftl";
    protected static Map<String, OptimizationStorage> objectiveCache = new ReferenceMap();

    protected OptimizationStorage(File rootSrc, File directory, String name) {
        super(rootSrc, directory, name);
    }

    @Override
    public String getPackage() {
        return OPTIMIZATION_PATH;
    }

    public static File getOptimizationDirectory() {
        File result = new File(OptimizationStorage.getContextDatabaseDirectory(), OPTIMIZATION_PATH);
        result.mkdirs();
        return result;
    }

    public static File getCommunityOptimizationDirectory() {
        File result = new File(OptimizationStorage.getCommunityDatabaseDirectory(), OPTIMIZATION_PATH);
        result.mkdirs();
        return result;
    }

    public static List<String> getOptimizationNames() {
        List<String> rules = OptimizationStorage.getStorageNames(OptimizationStorage.getOptimizationDirectory());
        rules.addAll(OptimizationStorage.getStorageNames(OptimizationStorage.getCommunityOptimizationDirectory()));
        return rules;
    }

    public static OptimizationStorage getOptimization(String name, CodeSourceStorage.Location ... location) {
        OptimizationStorage result = objectiveCache.get(name);
        if (result == null) {
            CodeSourceStorage.Location[] locs = OptimizationStorage.nonEmptyLocation(location);
            for (int i = 0; i < locs.length && result == null; ++i) {
                CodeSourceStorage.Location loc = locs[i];
                for (File dir : loc.getDirectories()) {
                    OptimizationStorage storage = new OptimizationStorage(dir, new File(dir, OPTIMIZATION_PATH), name);
                    File sFile = storage.getFile();
                    if (!sFile.isFile()) continue;
                    result = storage;
                    objectiveCache.put(name, result);
                }
            }
        }
        return result;
    }

    public static OptimizationStorage createOptimization(String name, CodeSourceStorage.Location location) {
        File dir = location.getDirectories()[0];
        OptimizationStorage storage = new OptimizationStorage(dir, new File(dir, OPTIMIZATION_PATH), name);
        return storage;
    }

    public static void checkout() throws VCSException {
        OptimizationStorage.checkout(IsisFish.config.getDatabaseDirectory(), OPTIMIZATION_PATH);
    }

    public static List<String> getNewOptimisationNames() {
        List<String> result = OptimizationStorage.getOptimizationNames();
        result.removeAll(OptimizationStorage.getRemoteOptimizationNames());
        return result;
    }

    public static List<String> getRemoteOptimizationNames() {
        File dir = OptimizationStorage.getOptimizationDirectory();
        return OptimizationStorage.getRemoteStorageNames(dir);
    }

    public static List<String> getNewRemoteOptimizationNames() {
        List<String> result = OptimizationStorage.getRemoteOptimizationNames();
        result.removeAll(OptimizationStorage.getOptimizationNames());
        return result;
    }
}

