package fr.ifremer.isisfish.ui.sensitivity;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.ui.SimulationUI;
import fr.ifremer.isisfish.ui.simulator.AdvancedParamsUI;
import fr.ifremer.isisfish.ui.simulator.ExportUI;
import fr.ifremer.isisfish.ui.simulator.ParamsUI;
import fr.ifremer.isisfish.ui.simulator.ResultChoiceUI;
import java.awt.LayoutManager;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class SensitivityUI extends SimulationUI {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_PARAMS_UI_REGION_STORAGE = "paramsUI.regionStorage";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJVVQU8TQRSeFgsUEBEUUDFBJSZetqCiRoiCaLWkKqGSEHtxtjtth2xnxplZWC7Gn+BP0LsXE2+ejAfPHrwY/4IxHrwa32y33S5sA+xhdzPvfd/73pvZb9//Qhkl0YUt7PuW9JimDWKtLm9uPrW3SEXfJ6oiqdBcouaVSqN0GQ067XWl0aVy0cBzITy3whuCM8I60AtFNKD0rktUnRCt0fk4oqJUrtQOL/jCky3Wtqgk1rd/fqffOK/fpRHyBagbgVamD0JFnRwrojR1NBqFSts452JWAxmSshroPW7WVlys1BPcIC/RK9RXRL0CSyDT6OLhWw44ArwvNBqeKdGG52JNOdsozGo0W5UWrUrSIPBUVFWpqlsetRRhimq6TfWuVYreNwpCBGy9wGVzZ/cZtm3irGFGNJowmn1L7UAL1moUiSD90ABuqI2CRle6FW7q49JaC3MNdqhNMdqhrMCEpw3Z/NG6CHFx4lMdySt1zhWRhvrm0ajbyDh5P/EFl/pwjT8Ic+MUw5Ioz9VQgFaIIcodSLQeQ8TpRrCzjVnF7FBrS+YOJFzeg4lTTnTMpEQqnEGeCphvH22IneB4iewMHKsCq3I4umdjn1rz1IVRsR8wZxYuJwSudgtc6xa43i0w3y1woxWQ6FxMNViPFVlP5A2pMspID5Y1mizvd6t1CDV9anKPTxnCIPpvfOz7p58f8y1z6oHapxNTO7wVTENILojU1JQ+0XQmT1M39xiLhTLKKuKCMQfGO5UgrBSGQRzUO2ngloFbj7CqA0Wm78fnL+MvvvWgdB4NuBw7eWzyCyir63DA69x1fHF3KVA0tNNvXNVo0+i4JDUwrRIk4xqManjRwRpP25Q5sPF3fJjFVMIs2oLs7Ne/Y6UPS615pEDfma7p0Uwyz1EvZS5lJLDr0IkT7XlQKOI5PHLcJA9OmeeICA/JreC+mNTwYMfHAba32BQxjTX8ImxPE2jZYJeCXszbvUNSm+W8uT1MZpgChv/U8F3YmQcAAA==";
    private static final Log log = LogFactory.getLog(SensitivityUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdvancedParamsUI advancedParamsUI;
    protected ExportUI exportUI;
    protected ParamsUI paramsUI;
    protected ResultChoiceUI resultChoiceUI;
    protected SensitivityChooserUI sensitivityChooserUI;
    protected SensitivityInputUI sensitivityInputUI;
    protected SensitivitySecondPassUI sensitivitySecondPassUI;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private SensitivityUI $SimulationUI0 = this;
    private TabInfo $TabInfo0;
    private TabInfo $TabInfo1;
    private TabInfo $TabInfo2;
    private TabInfo $TabInfo3;
    private TabInfo $TabInfo4;
    private TabInfo $TabInfo5;
    private TabInfo $TabInfo6;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    /**
         * Refresh all simulation launch UI.
         */
        @Override
        protected void regionStorageChanged() {
            boolean enabled = getRegionStorage() != null;
            bodyTabbedPane.setEnabledAt(1, enabled);
            bodyTabbedPane.setEnabledAt(2, enabled);
        }
    
        @Override
        public void refresh() {
            paramsUI.getHandler().refresh();
            resultChoiceUI.getHandler().refresh();
            exportUI.getHandler().refresh();
            advancedParamsUI.getHandler().refresh();
        }
    
        @Override
        public void selectParametersTab() {
            bodyTabbedPane.setSelectedIndex(0);
        }
    
        @Override
        public void setEnabledPrescriptTab(boolean selected) {
            // no prescript in AS
        }
    
        @Override
        public void setEnabledSimulationPlanTab(boolean selected) {
            // no simulation plan in AS
        }
    
        @Override
        public void setEnabledOptimizationTab(boolean selected) {
            // no optimisation.in AS
        }
    
        @Override
        public void refreshFactorTree() {
            sensitivityInputUI.getHandler().setFactorModel();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SensitivityUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SensitivityUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public SensitivityUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SensitivityUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SensitivityUI() {
        $initialize();
    }

    public SensitivityUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public SensitivityUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SensitivityUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public AdvancedParamsUI getAdvancedParamsUI() {
        return advancedParamsUI;
    }

    public ExportUI getExportUI() {
        return exportUI;
    }

    public ParamsUI getParamsUI() {
        return paramsUI;
    }

    public ResultChoiceUI getResultChoiceUI() {
        return resultChoiceUI;
    }

    public SensitivityChooserUI getSensitivityChooserUI() {
        return sensitivityChooserUI;
    }

    public SensitivityInputUI getSensitivityInputUI() {
        return sensitivityInputUI;
    }

    public SensitivitySecondPassUI getSensitivitySecondPassUI() {
        return sensitivitySecondPassUI;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    protected TabInfo get$TabInfo2() {
        return $TabInfo2;
    }

    protected TabInfo get$TabInfo3() {
        return $TabInfo3;
    }

    protected TabInfo get$TabInfo4() {
        return $TabInfo4;
    }

    protected TabInfo get$TabInfo5() {
        return $TabInfo5;
    }

    protected TabInfo get$TabInfo6() {
        return $TabInfo6;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBodyTabbedPane() {
        if (!allComponentsCreated) {
            return;
        }
        bodyTabbedPane.add(paramsUI);
        bodyTabbedPane.add(sensitivityInputUI);
        bodyTabbedPane.add(sensitivityChooserUI);
        bodyTabbedPane.add(exportUI);
        bodyTabbedPane.add(resultChoiceUI);
        bodyTabbedPane.add(advancedParamsUI);
        bodyTabbedPane.add(sensitivitySecondPassUI);
        $TabInfo0.addPropertyChangeListener(new TabInfoPropertyChangeListener(bodyTabbedPane, 0));
        bodyTabbedPane.setTitleAt(0, t("isisfish.params.title"));
        $TabInfo1.addPropertyChangeListener(new TabInfoPropertyChangeListener(bodyTabbedPane, 1));
        bodyTabbedPane.setTitleAt(1, t("isisfish.sensitivity.title"));
        bodyTabbedPane.setEnabledAt(1, false);
        $TabInfo2.addPropertyChangeListener(new TabInfoPropertyChangeListener(bodyTabbedPane, 2));
        bodyTabbedPane.setTitleAt(2, t("isisfish.sensitivityChooser.title"));
        bodyTabbedPane.setEnabledAt(2, false);
        $TabInfo3.addPropertyChangeListener(new TabInfoPropertyChangeListener(bodyTabbedPane, 3));
        bodyTabbedPane.setTitleAt(3, t("isisfish.export.title"));
        $TabInfo4.addPropertyChangeListener(new TabInfoPropertyChangeListener(bodyTabbedPane, 4));
        bodyTabbedPane.setTitleAt(4, t("isisfish.resultChoice.title"));
        $TabInfo5.addPropertyChangeListener(new TabInfoPropertyChangeListener(bodyTabbedPane, 5));
        bodyTabbedPane.setTitleAt(5, t("isisfish.advancedParameters.title"));
        $TabInfo6.addPropertyChangeListener(new TabInfoPropertyChangeListener(bodyTabbedPane, 6));
        bodyTabbedPane.setTitleAt(6, t("isisfish.sensitivity.secondpass.title"));
    }

    protected void createAdvancedParamsUI() {
        $objectMap.put("advancedParamsUI", advancedParamsUI = new AdvancedParamsUI(this));
        
        advancedParamsUI.setName("advancedParamsUI");
    }

    @Override
    protected void createBodyTabbedPane() {
        super.createBodyTabbedPane();
        bodyTabbedPane.setName("bodyTabbedPane");
    }

    protected void createExportUI() {
        $objectMap.put("exportUI", exportUI = new ExportUI(this));
        
        exportUI.setName("exportUI");
    }

    protected void createParamsUI() {
        $objectMap.put("paramsUI", paramsUI = new ParamsUI(this));
        
        paramsUI.setName("paramsUI");
        paramsUI.setSensitivity(true);
    }

    protected void createResultChoiceUI() {
        $objectMap.put("resultChoiceUI", resultChoiceUI = new ResultChoiceUI(this));
        
        resultChoiceUI.setName("resultChoiceUI");
        resultChoiceUI.setSensitivity(true);
    }

    protected void createSensitivityChooserUI() {
        $objectMap.put("sensitivityChooserUI", sensitivityChooserUI = new SensitivityChooserUI(this));
        
        sensitivityChooserUI.setName("sensitivityChooserUI");
    }

    protected void createSensitivityInputUI() {
        $objectMap.put("sensitivityInputUI", sensitivityInputUI = new SensitivityInputUI(this));
        
        sensitivityInputUI.setName("sensitivityInputUI");
    }

    protected void createSensitivitySecondPassUI() {
        $objectMap.put("sensitivitySecondPassUI", sensitivitySecondPassUI = new SensitivitySecondPassUI(this));
        
        sensitivitySecondPassUI.setName("sensitivitySecondPassUI");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBodyTabbedPane();
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$SimulationUI0", $SimulationUI0);
        createParamsUI();
        createSensitivityInputUI();
        createSensitivityChooserUI();
        createExportUI();
        createResultChoiceUI();
        createAdvancedParamsUI();
        createSensitivitySecondPassUI();
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new TabInfo());
        
        $TabInfo0.setTitle(t("isisfish.params.title"));
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new TabInfo());
        
        $TabInfo1.setEnabled(false);
        $TabInfo1.setTitle(t("isisfish.sensitivity.title"));
        // inline creation of $TabInfo2
        $objectMap.put("$TabInfo2", $TabInfo2 = new TabInfo());
        
        $TabInfo2.setEnabled(false);
        $TabInfo2.setTitle(t("isisfish.sensitivityChooser.title"));
        // inline creation of $TabInfo3
        $objectMap.put("$TabInfo3", $TabInfo3 = new TabInfo());
        
        $TabInfo3.setTitle(t("isisfish.export.title"));
        // inline creation of $TabInfo4
        $objectMap.put("$TabInfo4", $TabInfo4 = new TabInfo());
        
        $TabInfo4.setTitle(t("isisfish.resultChoice.title"));
        // inline creation of $TabInfo5
        $objectMap.put("$TabInfo5", $TabInfo5 = new TabInfo());
        
        $TabInfo5.setTitle(t("isisfish.advancedParameters.title"));
        // inline creation of $TabInfo6
        $objectMap.put("$TabInfo6", $TabInfo6 = new TabInfo());
        
        $TabInfo6.setTitle(t("isisfish.sensitivity.secondpass.title"));
        // inline creation of $SimulationUI0
        setName("$SimulationUI0");
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_PARAMS_UI_REGION_STORAGE, true ,"regionStorage") {
        
            @Override
            public void processDataBinding() {
                paramsUI.setRegionStorage(getRegionStorage());
            }
        });
    }

}