/*
 * #%L
 * IsisFish
 * 
 * $Id: SimulationPreScript.java 4156 2014-12-09 11:27:18Z echatellier $
 * $HeadURL: http://svn.codelutin.com/isis-fish/trunk/src/main/java/fr/ifremer/isisfish/simulator/SimulationPreScript.java $
 * %%
 * Copyright (C) 2014 Ifremer, Code Lutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.simulator;

import fr.ifremer.isisfish.util.Args;
import org.nuiton.topia.TopiaContext;

/**
 * Interface d'utilisation d'un prescript.
 * 
 * @author Eric Chatellier
 */
public interface SimulationPreScript {

    /**
     * Compute prescript
     * 
     * @param context simulation context
     * @param db database use during simulation
     * @throws Exception 
     */
    @Args({"context", "db"})
    public void compute(SimulationContext context, TopiaContext db) throws Exception;

}
