package fr.ifremer.isisfish.entities;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.generator.EntityTransformer", date = "Wed Jun 24 10:15:37 CEST 2015")
public abstract class SetOfVesselsAbstract extends TopiaEntityAbstract implements SetOfVessels {

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : numberOfVessels
     */
    protected int numberOfVessels;

    /**
     * <p>Co&ucirc;ts fixes d&eacute;caiss&eacute;s</p>
     * 
     * Nom de l'attribut en BD : fixedCosts
     */
    protected double fixedCosts;

    /**
     * Nom de l'attribut en BD : vesselCosts
     */
    protected double vesselCosts;

    /**
     * Nom de l'attribut en BD : capitalDeprecation
     */
    protected double capitalDeprecation;

    /**
     * Nom de l'attribut en BD : interestCost
     */
    protected double interestCost;

    /**
     * Nom de l'attribut en BD : comment
     */
    protected String comment;

    /**
     * Nom de l'attribut en BD : technicalEfficiencyEquation
     */
    protected Equation technicalEfficiencyEquation;

    /**
     * Nom de l'attribut en BD : port
     */
    protected Port port;

    /**
     * Nom de l'attribut en BD : possibleMetiers
     */
    protected Collection<EffortDescription> possibleMetiers;

    /**
     * Nom de l'attribut en BD : vesselType
     */
    protected VesselType vesselType;

    private static final long serialVersionUID = 7004612767439217763L;

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(SetOfVessels.class).update(this);
}

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(SetOfVessels.class).delete(this);
}

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(EntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_NUMBER_OF_VESSELS, int.class, numberOfVessels);
        visitor.visit(this, PROPERTY_FIXED_COSTS, double.class, fixedCosts);
        visitor.visit(this, PROPERTY_VESSEL_COSTS, double.class, vesselCosts);
        visitor.visit(this, PROPERTY_CAPITAL_DEPRECATION, double.class, capitalDeprecation);
        visitor.visit(this, PROPERTY_INTEREST_COST, double.class, interestCost);
        visitor.visit(this, PROPERTY_COMMENT, String.class, comment);
        visitor.visit(this, PROPERTY_TECHNICAL_EFFICIENCY_EQUATION, Equation.class, technicalEfficiencyEquation);
        visitor.visit(this, PROPERTY_PORT, Port.class, port);
        visitor.visit(this, PROPERTY_POSSIBLE_METIERS, Collection.class, EffortDescription.class, possibleMetiers);
        visitor.visit(this, PROPERTY_VESSEL_TYPE, VesselType.class, vesselType);
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        fireOnPreWrite(PROPERTY_NAME, oldValue, name);
        this.name = name;
        fireOnPostWrite(PROPERTY_NAME, oldValue, name);
    }

    @Override
    public String getName() {
        String result = this.name;

        return result;
    }

    @Override
    public void setNumberOfVessels(int numberOfVessels) {
        int oldValue = this.numberOfVessels;
        fireOnPreWrite(PROPERTY_NUMBER_OF_VESSELS, oldValue, numberOfVessels);
        this.numberOfVessels = numberOfVessels;
        fireOnPostWrite(PROPERTY_NUMBER_OF_VESSELS, oldValue, numberOfVessels);
    }

    @Override
    public int getNumberOfVessels() {
        int result = this.numberOfVessels;

        return result;
    }

    @Override
    public void setFixedCosts(double fixedCosts) {
        double oldValue = this.fixedCosts;
        fireOnPreWrite(PROPERTY_FIXED_COSTS, oldValue, fixedCosts);
        this.fixedCosts = fixedCosts;
        fireOnPostWrite(PROPERTY_FIXED_COSTS, oldValue, fixedCosts);
    }

    @Override
    public double getFixedCosts() {
        double result = this.fixedCosts;

        return result;
    }

    @Override
    public void setVesselCosts(double vesselCosts) {
        double oldValue = this.vesselCosts;
        fireOnPreWrite(PROPERTY_VESSEL_COSTS, oldValue, vesselCosts);
        this.vesselCosts = vesselCosts;
        fireOnPostWrite(PROPERTY_VESSEL_COSTS, oldValue, vesselCosts);
    }

    @Override
    public double getVesselCosts() {
        double result = this.vesselCosts;

        return result;
    }

    @Override
    public void setCapitalDeprecation(double capitalDeprecation) {
        double oldValue = this.capitalDeprecation;
        fireOnPreWrite(PROPERTY_CAPITAL_DEPRECATION, oldValue, capitalDeprecation);
        this.capitalDeprecation = capitalDeprecation;
        fireOnPostWrite(PROPERTY_CAPITAL_DEPRECATION, oldValue, capitalDeprecation);
    }

    @Override
    public double getCapitalDeprecation() {
        double result = this.capitalDeprecation;

        return result;
    }

    @Override
    public void setInterestCost(double interestCost) {
        double oldValue = this.interestCost;
        fireOnPreWrite(PROPERTY_INTEREST_COST, oldValue, interestCost);
        this.interestCost = interestCost;
        fireOnPostWrite(PROPERTY_INTEREST_COST, oldValue, interestCost);
    }

    @Override
    public double getInterestCost() {
        double result = this.interestCost;

        return result;
    }

    @Override
    public void setComment(String comment) {
        String oldValue = this.comment;
        fireOnPreWrite(PROPERTY_COMMENT, oldValue, comment);
        this.comment = comment;
        fireOnPostWrite(PROPERTY_COMMENT, oldValue, comment);
    }

    @Override
    public String getComment() {
        String result = this.comment;

        return result;
    }

    @Override
    public void setTechnicalEfficiencyEquation(Equation technicalEfficiencyEquation) {
        Equation oldValue = this.technicalEfficiencyEquation;
        fireOnPreWrite(PROPERTY_TECHNICAL_EFFICIENCY_EQUATION, oldValue, technicalEfficiencyEquation);
        this.technicalEfficiencyEquation = technicalEfficiencyEquation;
        fireOnPostWrite(PROPERTY_TECHNICAL_EFFICIENCY_EQUATION, oldValue, technicalEfficiencyEquation);
    }

    @Override
    public Equation getTechnicalEfficiencyEquation() {
        Equation result = this.technicalEfficiencyEquation;

        return result;
    }

    @Override
    public void setPort(Port port) {
        Port oldValue = this.port;
        fireOnPreWrite(PROPERTY_PORT, oldValue, port);
        this.port = port;
        fireOnPostWrite(PROPERTY_PORT, oldValue, port);
    }

    @Override
    public Port getPort() {
        Port result = this.port;

        return result;
    }

    @Override
    public void addPossibleMetiers(EffortDescription possibleMetiers) {
        fireOnPreWrite(PROPERTY_POSSIBLE_METIERS, null, possibleMetiers);
        if (this.possibleMetiers == null) {
            this.possibleMetiers = new ArrayList<EffortDescription>();
        }

        this.possibleMetiers.add(possibleMetiers);
        fireOnPostWrite(PROPERTY_POSSIBLE_METIERS, this.possibleMetiers.size(), null, possibleMetiers);
    }

    @Override
    public void addAllPossibleMetiers(Collection<EffortDescription> possibleMetiers) {
        if (possibleMetiers == null) {
            return;
        }
        for (EffortDescription item : possibleMetiers) {
            addPossibleMetiers(item);
        }
    }

    @Override
    public void setPossibleMetiers(Collection<EffortDescription> possibleMetiers) {
        // Copy elements to keep data for fire with new reference
        Collection<EffortDescription> oldValue = this.possibleMetiers != null ? new ArrayList<EffortDescription>(this.possibleMetiers) : null;
        fireOnPreWrite(PROPERTY_POSSIBLE_METIERS, oldValue, possibleMetiers);
        this.possibleMetiers = possibleMetiers;
        fireOnPostWrite(PROPERTY_POSSIBLE_METIERS, oldValue, possibleMetiers);
    }

    @Override
    public void removePossibleMetiers(EffortDescription possibleMetiers) {
        fireOnPreWrite(PROPERTY_POSSIBLE_METIERS, possibleMetiers, null);
        if (this.possibleMetiers == null || !this.possibleMetiers.remove(possibleMetiers)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_POSSIBLE_METIERS, this.possibleMetiers.size() + 1, possibleMetiers, null);
    }

    @Override
    public void clearPossibleMetiers() {
        if (this.possibleMetiers == null) {
            return;
        }
        Collection<EffortDescription> oldValue = new ArrayList<EffortDescription>(this.possibleMetiers);
        fireOnPreWrite(PROPERTY_POSSIBLE_METIERS, oldValue, this.possibleMetiers);
        this.possibleMetiers.clear();
        fireOnPostWrite(PROPERTY_POSSIBLE_METIERS, oldValue, this.possibleMetiers);
    }

    @Override
    public Collection<EffortDescription> getPossibleMetiers() {
        return possibleMetiers;
    }

    @Override
    public EffortDescription getPossibleMetiersByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(possibleMetiers, topiaId);
    }

    @Override
    public EffortDescription getPossibleMetiers(Metier possibleMetiers) {
        if (possibleMetiers == null || this.possibleMetiers == null) {
            return null;
        }
        for (EffortDescription item : this.possibleMetiers) {
            if (possibleMetiers.equals(item.getPossibleMetiers())) {
                return item;
            }
        }
        return null;
    }

    @Override
    public int sizePossibleMetiers() {
        if (possibleMetiers == null) {
            return 0;
        }
        return possibleMetiers.size();
    }

    @Override
    public boolean isPossibleMetiersEmpty() {
        int size = sizePossibleMetiers();
        return size == 0;
    }

    @Override
    public void setVesselType(VesselType vesselType) {
        VesselType oldValue = this.vesselType;
        fireOnPreWrite(PROPERTY_VESSEL_TYPE, oldValue, vesselType);
        this.vesselType = vesselType;
        fireOnPostWrite(PROPERTY_VESSEL_TYPE, oldValue, vesselType);
    }

    @Override
    public VesselType getVesselType() {
        VesselType result = this.vesselType;

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        tmp.add(getTechnicalEfficiencyEquation());

        {
            org.nuiton.topia.persistence.TopiaDAO<EffortDescription> dao = ((TopiaContextImplementor) getTopiaContext()).getDAO(EffortDescription.class);
            List<EffortDescription> findAllByProperties = dao.findAllByProperties("setOfVessels", this);
            if (findAllByProperties != null) {
                tmp.addAll(findAllByProperties);
            }
        }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_NAME, this.name).
            append(PROPERTY_NUMBER_OF_VESSELS, this.numberOfVessels).
            append(PROPERTY_FIXED_COSTS, this.fixedCosts).
            append(PROPERTY_VESSEL_COSTS, this.vesselCosts).
            append(PROPERTY_CAPITAL_DEPRECATION, this.capitalDeprecation).
            append(PROPERTY_INTEREST_COST, this.interestCost).
            append(PROPERTY_COMMENT, this.comment).
            append(PROPERTY_TECHNICAL_EFFICIENCY_EQUATION, this.technicalEfficiencyEquation).
            append(PROPERTY_PORT, this.port).
            append(PROPERTY_VESSEL_TYPE, this.vesselType).
         toString();
        return result;
    }

} //SetOfVesselsAbstract
