/*
 * #%L
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2013 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.widget;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;

import javax.swing.JComponent;

import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.AbstractLayerUI;

public class DummyLayerUI extends AbstractLayerUI<JComponent> {

    /** serialVersionUID. */
    private static final long serialVersionUID = 309245880711380974L;

    @Override
    protected void paintLayer(Graphics2D g2, JXLayer<? extends JComponent> l) {
        super.paintLayer(g2, l);

        // position
        //g2.translate(-35, 90); // top left
        g2.translate(l.getBounds().getMaxX() - 160, l.getBounds().getMaxY()); // bottom right

        // yellow backgroung 
        g2.rotate(Math.PI * -42 / 180);
        g2.setColor(Color.YELLOW);
        g2.fillRect(10, 10, 200, 30);

        // text
        g2.translate(70, 15);
        g2.setFont(new Font("Dialog", Font.BOLD, 16));
        g2.setColor(Color.BLACK);
        g2.drawString("Maquette",10,10);
        
        // for test only
        g2.translate(-3, 10);
        g2.setFont(new Font("Dialog", Font.ITALIC, 10));
        g2.setColor(Color.BLACK);
        g2.drawString("(non fonctionnelle)",10,10);
    }
}
