/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coselmar.persistence.entity;

import fr.ifremer.coselmar.persistence.DaoUtils;
import fr.ifremer.coselmar.persistence.entity.AbstractDocumentTopiaDao;
import fr.ifremer.coselmar.persistence.entity.CoselmarUser;
import fr.ifremer.coselmar.persistence.entity.Document;
import fr.ifremer.coselmar.persistence.entity.Privacy;
import java.util.HashMap;
import java.util.List;

public class DocumentTopiaDao
extends AbstractDocumentTopiaDao<Document> {
    public List<Document> findAllContainingAllKeywords(List<String> keywords) {
        StringBuilder hqlBuilder = new StringBuilder("FROM " + Document.class.getName() + " D");
        HashMap<String, Object> args = new HashMap<String, Object>();
        if (keywords != null) {
            hqlBuilder.append(" WHERE ( 1 = 0 ");
            for (String keyword : keywords) {
                String nameClause = DaoUtils.orAttributeLike("D", "name", args, keyword);
                String summaryClause = DaoUtils.orAttributeLike("D", "summary", args, keyword);
                String authorsClause = DaoUtils.orAttributeLike("D", "Authors", args, keyword);
                String containsKeyword = DaoUtils.orAttributeContains("D", "keywords", args, keyword);
                hqlBuilder.append(nameClause);
                hqlBuilder.append(summaryClause);
                hqlBuilder.append(authorsClause);
                hqlBuilder.append(containsKeyword);
            }
            hqlBuilder.append(" )");
        }
        List documents = this.forHql(hqlBuilder.toString(), args).findAll();
        return documents;
    }

    public List<Document> findAllFilterByUser(CoselmarUser currentUser, List<String> keywords) {
        StringBuilder hqlBuilder = new StringBuilder("FROM " + Document.class.getName() + " D");
        HashMap<String, Object> args = new HashMap<String, Object>();
        String privacyPublicCondition = DaoUtils.getQueryForAttributeEquals("D", "privacy", args, (Object)Privacy.PUBLIC, "");
        hqlBuilder.append(" WHERE ( " + privacyPublicCondition);
        String privacyPrivateCondition = DaoUtils.getQueryForAttributeEquals("D", "privacy", args, (Object)Privacy.PRIVATE, "");
        String ownerCondition = DaoUtils.andAttributeEquals("D", "owner", args, currentUser);
        hqlBuilder.append(" OR ( " + privacyPrivateCondition + " " + ownerCondition + " ) )");
        if (keywords != null) {
            hqlBuilder.append(" AND ( 1 = 0 ");
            for (String keyword : keywords) {
                String nameClause = DaoUtils.orAttributeLike("D", "name", args, keyword);
                String summaryClause = DaoUtils.orAttributeLike("D", "summary", args, keyword);
                String authorsClause = DaoUtils.orAttributeLike("D", "Authors", args, keyword);
                String containsKeyword = DaoUtils.orAttributeContains("D", "keywords", args, keyword);
                hqlBuilder.append(nameClause);
                hqlBuilder.append(summaryClause);
                hqlBuilder.append(authorsClause);
                hqlBuilder.append(containsKeyword);
            }
            hqlBuilder.append(" )");
        }
        List documents = this.forHql(hqlBuilder.toString(), args).findAll();
        return documents;
    }

    public List<String> findAllKeywords() {
        StringBuilder hqlBuilder = new StringBuilder("SELECT DISTINCT(keywords) FROM " + Document.class.getName() + " D " + " INNER JOIN D." + "keywords" + " keywords ");
        List values = this.findAll(hqlBuilder.toString());
        return values;
    }

    public List<String> findAllTypes() {
        StringBuilder hqlBuilder = new StringBuilder("SELECT DISTINCT(D. type) FROM " + Document.class.getName() + " D ");
        List values = this.findAll(hqlBuilder.toString());
        return values;
    }
}

