/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.jtb.misc.toolkit;

import EDU.purdue.jtb.misc.ClassInfo;
import EDU.purdue.jtb.misc.Errors;
import EDU.purdue.jtb.misc.FileExistsException;
import EDU.purdue.jtb.misc.Globals;
import EDU.purdue.jtb.misc.Spacing;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class SchemeVisitorBuilder {
    public static final String visitorName = "SchemeTreeBuilder";
    public static final String outFilename = "SchemeTreeBuilder.java";
    public static final int INDENT_AMT = 3;
    private Vector classList;
    private File visitorDir;
    private PrintWriter out;

    public SchemeVisitorBuilder(Vector classes) {
        this.classList = classes;
        this.visitorDir = new File(Globals.visitorDir);
        if (!this.visitorDir.exists()) {
            this.visitorDir.mkdir();
        }
    }

    public void generateSchemeBuilder() throws FileExistsException {
        try {
            File file = new File(this.visitorDir, outFilename);
            if (Globals.noOverwrite && file.exists()) {
                throw new FileExistsException(outFilename);
            }
            this.out = new PrintWriter(new FileOutputStream(file), false);
            Spacing spc = new Spacing(3);
            boolean firstProd = true;
            this.out.println(Globals.fileHeader(spc));
            this.out.println();
            this.out.println(spc.spc + "package " + Globals.visitorPackage + ";");
            if (!Globals.visitorPackage.equals(Globals.nodePackage)) {
                this.out.println(spc.spc + "import " + Globals.nodePackage + ".*;");
            }
            this.out.println(spc.spc + "import java.util.*;");
            this.out.println(spc.spc + "import java.io.*;");
            this.out.println();
            this.out.println(spc.spc + "/**");
            this.out.println(spc.spc + " * Generates a syntax tree in the Scheme " + "language.");
            this.out.println(spc.spc + " */");
            this.out.println(spc.spc + "public class " + visitorName + " extends " + "DepthFirstVisitor" + " {");
            spc.updateSpc(1);
            this.out.println(spc.spc + "PrintWriter out;");
            this.out.println();
            this.printAutoMethods();
            this.out.println();
            Enumeration e = this.classList.elements();
            while (e.hasMoreElements()) {
                ClassInfo cur = (ClassInfo)e.nextElement();
                String name = cur.getName();
                String typeF1 = (String)cur.getTypeList().elementAt(0);
                this.out.println(spc.spc + "/**");
                if (Globals.javaDocComments) {
                    this.out.println(spc.spc + " * <PRE>");
                }
                this.out.println(cur.getEbnfProduction(spc));
                if (Globals.javaDocComments) {
                    this.out.println(spc.spc + " * </PRE>");
                }
                this.out.println(spc.spc + " */");
                this.out.print(spc.spc + "public void visit");
                this.out.println("(" + name + " n) {");
                spc.updateSpc(1);
                if (firstProd) {
                    this.out.println(spc.spc + "out.print(\"(define root '(" + name + " \");");
                } else if (cur.getNameList().size() > 1 || !typeF1.equals("NodeChoice")) {
                    this.out.println(spc.spc + "out.print(\"(" + name + " \");");
                }
                Enumeration f = cur.getNameList().elements();
                while (f.hasMoreElements()) {
                    this.out.println(spc.spc + "n." + (String)f.nextElement() + ".accept(this);");
                }
                if (firstProd) {
                    this.out.println(spc.spc + "out.print(\")) \");");
                    this.out.println(spc.spc + "out.flush();");
                    this.out.println(spc.spc + "out.close();");
                    firstProd = false;
                } else if (cur.getNameList().size() > 1 || !typeF1.equals("NodeChoice")) {
                    this.out.println(spc.spc + "out.print(\") \");");
                }
                spc.updateSpc(-1);
                this.out.println(spc.spc + "}\n");
            }
            spc.updateSpc(-1);
            this.out.println(spc.spc + "}");
            this.out.flush();
            this.out.close();
        }
        catch (IOException e) {
            Errors.hardErr("Could not generate SchemeTreeBuilder.java");
        }
    }

    private void printAutoMethods() {
        this.out.println("   public SchemeTreeBuilder() {\n      this(System.out);\n   }\n\n   public SchemeTreeBuilder(Writer w) {\n      out = new PrintWriter(w);\n   }\n\n   public SchemeTreeBuilder(OutputStream o) {\n      out = new PrintWriter(o);\n   }\n\n   private String toSchemeString(String s) {\n      int len = s.length();\n      StringBuffer temp = new StringBuffer(s);\n\n      for ( int i = 0; i < len; i++ )\n         if ( temp.charAt(i) == '\"' ) {\n            temp.insert(i, '\\\\');\n            ++i; ++len;\n         }\n\n      return temp.toString();\n   }\n\n");
        this.out.println("   public void visit(NodeList n) {\n      out.print(\"(\");\n      for ( Enumeration<Node> e = n.elements(); e.hasMoreElements(); )\n         e.nextElement().accept(this);\n      out.print(\") \");\n   }\n\n   public void visit(NodeListOptional n) {\n      out.print(\"( \");\n      for ( Enumeration<Node> e = n.elements(); e.hasMoreElements(); )\n         e.nextElement().accept(this);\n      out.print(\") \");\n   }\n\n   public void visit(NodeOptional n) {\n      out.print(\"(\");\n      if ( n.present() )\n         n.node.accept(this);\n      out.print(\") \");\n   }\n\n   public void visit(NodeToken n) {\n      out.print(\"\\\"\" + toSchemeString(n.tokenImage) + \"\\\" \");\n   }\n");
    }
}

