/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.jtb.misc.toolkit;

import EDU.purdue.jtb.misc.ClassInfo;
import EDU.purdue.jtb.misc.Errors;
import EDU.purdue.jtb.misc.FileExistsException;
import EDU.purdue.jtb.misc.Globals;
import EDU.purdue.jtb.misc.Spacing;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class OldDepthFirstVisitorBuilder {
    public static final String visitorName = "DepthFirstVisitor";
    public static final String outFilename = "DepthFirstVisitor.java";
    public static final int INDENT_AMT = 3;
    private Vector classList;
    private File visitorDir;

    public OldDepthFirstVisitorBuilder(Vector classes) {
        this.classList = classes;
        this.visitorDir = new File(Globals.visitorDir);
        if (!this.visitorDir.exists()) {
            this.visitorDir.mkdir();
        }
    }

    public void generateDepthFirstVisitor() throws FileExistsException {
        try {
            File file = new File(this.visitorDir, outFilename);
            if (Globals.noOverwrite && file.exists()) {
                throw new FileExistsException(outFilename);
            }
            PrintWriter out = new PrintWriter(new FileOutputStream(file), false);
            Spacing spc = new Spacing(3);
            out.println(Globals.fileHeader(spc));
            out.println();
            out.println(spc.spc + "package " + Globals.visitorPackage + ";");
            if (!Globals.visitorPackage.equals(Globals.nodePackage)) {
                out.println(spc.spc + "import " + Globals.nodePackage + ".*;");
            }
            out.println(spc.spc + "import java.util.*;\n");
            out.println(spc.spc + "/**");
            out.println(spc.spc + " * Provides default methods which visit each " + "node in the tree in depth-first");
            out.println(spc.spc + " * order.  Your visitors may extend this class.");
            out.println(spc.spc + " */");
            out.println(spc.spc + "public class " + visitorName + " implements " + "Visitor" + " {");
            this.printAutoVisitorMethods(out);
            spc.updateSpc(1);
            out.println(spc.spc + "//");
            out.println(spc.spc + "// User-generated visitor methods below");
            out.println(spc.spc + "//");
            out.println();
            Enumeration e = this.classList.elements();
            while (e.hasMoreElements()) {
                ClassInfo cur = (ClassInfo)e.nextElement();
                String name = cur.getName();
                out.println(spc.spc + "/**");
                if (Globals.javaDocComments) {
                    out.println(spc.spc + " * <PRE>");
                }
                out.println(cur.getEbnfProduction(spc));
                if (Globals.javaDocComments) {
                    out.println(spc.spc + " * </PRE>");
                }
                out.println(spc.spc + " */");
                out.print(spc.spc + "public void visit");
                out.println("(" + name + " n) {");
                spc.updateSpc(1);
                Enumeration f = cur.getNameList().elements();
                while (f.hasMoreElements()) {
                    out.println(spc.spc + "n." + (String)f.nextElement() + ".accept(this);");
                }
                spc.updateSpc(-1);
                out.println(spc.spc + "}\n");
            }
            spc.updateSpc(-1);
            out.println(spc.spc + "}");
            out.flush();
            out.close();
        }
        catch (IOException e) {
            Errors.hardErr("Could not generate DepthFirstVisitor.java");
        }
    }

    private void printAutoVisitorMethods(PrintWriter out) {
        out.println("   //");
        out.println("   // Auto class visitors--probably don't need to be overridden.");
        out.println("   //");
        out.println(OldDepthFirstVisitorBuilder.getNodeListVisitorStr());
        out.println(OldDepthFirstVisitorBuilder.getNodeListOptionalVisitorStr());
        out.println(OldDepthFirstVisitorBuilder.getNodeOptionalVisitorStr());
        out.println(OldDepthFirstVisitorBuilder.getNodeSequenceVisitorStr());
        out.println(OldDepthFirstVisitorBuilder.getNodeTokenVisitorStr());
    }

    static String getNodeListVisitorStr() {
        StringBuffer buf = new StringBuffer(240);
        buf.append("   public void visit(NodeList n) {\n");
        buf.append("      for ( Enumeration<Node> e = n.elements(); e.hasMoreElements(); )\n         e.nextElement().accept(this);\n   }\n");
        return buf.toString();
    }

    static String getNodeListOptionalVisitorStr() {
        StringBuffer buf = new StringBuffer(300);
        buf.append("   public void visit(NodeListOptional n) {\n");
        buf.append("      if ( n.present() )\n         for ( Enumeration<Node> e = n.elements(); e.hasMoreElements(); )\n            e.nextElement().accept(this);\n   }\n");
        return buf.toString();
    }

    static String getNodeOptionalVisitorStr() {
        StringBuffer buf = new StringBuffer(250);
        buf.append("   public void visit(NodeOptional n) {\n");
        buf.append("      if ( n.present() )\n         n.node.accept(this);\n   }\n");
        return buf.toString();
    }

    static String getNodeSequenceVisitorStr() {
        StringBuffer buf = new StringBuffer(250);
        buf.append("   public void visit(NodeSequence n) {\n");
        buf.append("      for ( Enumeration<Node> e = n.elements(); e.hasMoreElements(); )\n         e.nextElement().accept(this);\n   }\n");
        return buf.toString();
    }

    static String getNodeTokenVisitorStr() {
        return "   public void visit(NodeToken n) { }\n";
    }
}

