/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.jtb.misc;

import EDU.purdue.jtb.misc.ClassInfo;
import EDU.purdue.jtb.misc.Errors;
import EDU.purdue.jtb.misc.FileExistsException;
import EDU.purdue.jtb.misc.Globals;
import EDU.purdue.jtb.misc.NoArguAutoClasses;
import EDU.purdue.jtb.misc.Spacing;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class NoArguFileGenerator {
    public static final int INDENT_AMT = 3;
    private Vector classList;
    private File visitorDir;

    public NoArguFileGenerator(Vector classes) {
        this.classList = classes;
        this.visitorDir = new File(Globals.visitorDir);
        if (!this.visitorDir.exists()) {
            this.visitorDir.mkdir();
        } else if (!this.visitorDir.isDirectory()) {
            Errors.softErr("\"" + Globals.visitorDir + "\" exists but is not a " + "directory.");
        }
    }

    public void generateVisitorFile() throws FileExistsException {
        try {
            File file = new File(this.visitorDir, "GJNoArguVisitor.java");
            if (Globals.noOverwrite && file.exists()) {
                throw new FileExistsException("GJNoArguVisitor.java");
            }
            PrintWriter out = new PrintWriter(new FileOutputStream(file), false);
            Spacing spc = new Spacing(3);
            out.println(Globals.fileHeader(spc));
            out.println();
            out.println(spc.spc + "package " + Globals.visitorPackage + ";");
            if (!Globals.visitorPackage.equals(Globals.nodePackage)) {
                out.println(spc.spc + "import " + Globals.nodePackage + ".*;");
            }
            out.println(spc.spc + "import java.util.*;\n");
            out.println(spc.spc + "/**");
            out.println(spc.spc + " * All GJ visitors with no argument must implement this interface.");
            out.println(spc.spc + " */\n");
            out.println(spc.spc + "public interface " + "GJNoArguVisitor" + "<R> {\n");
            this.printAutoVisitorMethods(out);
            spc.updateSpc(1);
            out.println(spc.spc + "//");
            out.println(spc.spc + "// User-generated visitor methods below");
            out.println(spc.spc + "//");
            out.println();
            Enumeration e = this.classList.elements();
            while (e.hasMoreElements()) {
                ClassInfo cur = (ClassInfo)e.nextElement();
                String name = cur.getName();
                out.println(spc.spc + "/**");
                if (Globals.javaDocComments) {
                    out.println(spc.spc + " * <PRE>");
                }
                out.println(cur.getEbnfProduction(spc));
                if (Globals.javaDocComments) {
                    out.println(spc.spc + " * </PRE>");
                }
                out.println(spc.spc + " */");
                out.print(spc.spc + "public R visit");
                out.println("(" + name + " n);\n");
            }
            spc.updateSpc(-1);
            out.println(spc.spc + "}\n");
            out.flush();
            out.close();
        }
        catch (IOException e) {
            Errors.hardErr(e);
        }
    }

    private void printAutoVisitorMethods(PrintWriter out) {
        out.println("   //");
        out.println("   // GJ Auto class visitors with no argument");
        out.println("   //\n");
        out.print(NoArguAutoClasses.getNodeListVisitorStr());
        out.print(NoArguAutoClasses.getNodeListOptionalVisitorStr());
        out.print(NoArguAutoClasses.getNodeOptionalVisitorStr());
        out.print(NoArguAutoClasses.getNodeSequenceVisitorStr());
        out.print(NoArguAutoClasses.getNodeTokenVisitorStr());
        out.println();
    }
}

