/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.jtb.misc;

import EDU.purdue.jtb.misc.Errors;
import EDU.purdue.jtb.misc.FieldNameGenerator;
import EDU.purdue.jtb.misc.Globals;
import EDU.purdue.jtb.misc.Spacing;
import EDU.purdue.jtb.syntaxtree.Expansion;
import EDU.purdue.jtb.syntaxtree.ExpansionChoices;
import EDU.purdue.jtb.syntaxtree.ExpansionUnit;
import EDU.purdue.jtb.syntaxtree.ExpansionUnitTerm;
import EDU.purdue.jtb.syntaxtree.LocalLookahead;
import EDU.purdue.jtb.syntaxtree.Node;
import EDU.purdue.jtb.syntaxtree.NodeChoice;
import EDU.purdue.jtb.syntaxtree.NodeOptional;
import EDU.purdue.jtb.syntaxtree.NodeSequence;
import EDU.purdue.jtb.syntaxtree.NodeToken;
import EDU.purdue.jtb.visitor.Printer;
import java.io.PrintWriter;
import java.util.Enumeration;

class CommentPrinter
extends Printer {
    private boolean visitedLookahead = false;
    private Spacing spc;
    private int nestLevel = 0;
    private int fieldNum = 0;
    private FieldNameGenerator nameGen = new FieldNameGenerator();

    CommentPrinter(PrintWriter w, Spacing s) {
        super(w);
        this.spc = s;
    }

    public void visit(NodeToken n) {
        if (!Globals.javaDocComments) {
            this.out.print(n.tokenImage);
        } else {
            for (int i = 0; i < n.tokenImage.length(); ++i) {
                char c = n.tokenImage.charAt(i);
                if (c == '<') {
                    this.out.print("&lt;");
                    continue;
                }
                if (c == '>') {
                    this.out.print("&gt;");
                    continue;
                }
                this.out.print(c);
            }
        }
    }

    public void visit(LocalLookahead n) {
        this.visitedLookahead = true;
    }

    public void visit(ExpansionChoices n) {
        if (!n.f1.present()) {
            n.f0.accept(this);
            return;
        }
        if (this.nestLevel == 0) {
            this.out.print(this.spc.spc + " * " + this.nameGen.curFieldName("NodeChoice") + " -> ");
        }
        ++this.nestLevel;
        n.f0.accept(this);
        --this.nestLevel;
        Enumeration<Node> e = n.f1.elements();
        while (e.hasMoreElements()) {
            NodeSequence seq = (NodeSequence)e.nextElement();
            if (this.nestLevel == 0) {
                this.out.println();
                this.out.print(this.spc.spc + " *       ");
            } else {
                this.out.print(" ");
            }
            this.out.print(seq.elementAt(0) + " ");
            ++this.nestLevel;
            seq.elementAt(1).accept(this);
            --this.nestLevel;
        }
    }

    public void visit(Expansion n) {
        if (!n.f0.present()) {
            return;
        }
        Enumeration<Node> e = n.f0.elements();
        ExpansionUnit unit = (ExpansionUnit)e.nextElement();
        this.visitedLookahead = false;
        if (this.nestLevel == 0 && unit.f0.which != 0 && unit.f0.which != 1) {
            this.out.print(this.spc.spc + " * " + this.nameGen.curFieldName(this.getUnitName(unit)) + " -> ");
        }
        ++this.nestLevel;
        if (unit.f0.which != 1) {
            unit.accept(this);
        }
        --this.nestLevel;
        while (e.hasMoreElements()) {
            unit = (ExpansionUnit)e.nextElement();
            if (!this.visitedLookahead) {
                if (unit.f0.which != 0 && unit.f0.which != 1) {
                    if (this.nestLevel == 0) {
                        this.out.println();
                        this.out.print(this.spc.spc + " * " + this.nameGen.curFieldName(this.getUnitName(unit)) + " -> ");
                    } else {
                        this.out.print(" ");
                    }
                }
            } else {
                this.visitedLookahead = false;
            }
            ++this.nestLevel;
            if (unit.f0.which != 1) {
                unit.accept(this);
            }
            --this.nestLevel;
        }
    }

    private String getUnitName(ExpansionUnit n) {
        switch (n.f0.which) {
            case 2: {
                NodeSequence seq = (NodeSequence)n.f0.choice;
                NodeOptional ebnfMod = (NodeOptional)seq.elementAt(3);
                if (ebnfMod.present()) {
                    NodeChoice modChoice = (NodeChoice)ebnfMod.node;
                    String mod = ((NodeToken)modChoice.choice).tokenImage;
                    return this.nameGen.getNameForMod(mod);
                }
                ExpansionChoices ec = (ExpansionChoices)seq.elementAt(1);
                if (ec.f1.present()) {
                    return "NodeChoice";
                }
                return "NodeSequence";
            }
            case 3: {
                return "NodeOptional";
            }
            case 4: {
                NodeSequence seq = (NodeSequence)n.f0.choice;
                ExpansionUnitTerm term = (ExpansionUnitTerm)seq.elementAt(1);
                if (term.f0.which == 0) {
                    return "NodeToken";
                }
                NodeSequence s = (NodeSequence)term.f0.choice;
                return ((NodeToken)s.elementAt((int)0)).tokenImage;
            }
        }
        Errors.hardErr("n.f0.which = " + String.valueOf(n.f0.which));
        throw new Error("Error in CommentPrinter.getUnitName()");
    }
}

