/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.engine.impl.eventproducer;

import de.huxhorn.lilith.data.converter.Converter;
import de.huxhorn.lilith.data.converter.ConverterRegistry;
import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import de.huxhorn.lilith.engine.impl.eventproducer.AbstractStreamEventProducer;
import de.huxhorn.lilith.engine.impl.eventproducer.SourceIdentifierUpdater;
import de.huxhorn.sulky.buffers.AppendOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertingStreamEventProducer<T extends Serializable>
extends AbstractStreamEventProducer<T> {
    private ConverterRegistry<T> converterRegistry;
    private Converter<T> converter;

    public ConvertingStreamEventProducer(SourceIdentifier sourceIdentifier, AppendOperation<EventWrapper<T>> eventQueue, SourceIdentifierUpdater<T> sourceIdentifierUpdater, InputStream inputStream, ConverterRegistry<T> converterRegistry) throws IOException {
        super(sourceIdentifier, eventQueue, sourceIdentifierUpdater, inputStream);
        this.setConverterRegistry(converterRegistry);
    }

    public ConverterRegistry<T> getConverterRegistry() {
        return this.converterRegistry;
    }

    public void setConverterRegistry(ConverterRegistry<T> converterRegistry) {
        if (converterRegistry == null) {
            throw new IllegalArgumentException("converterRegistry must not be null!");
        }
        this.converterRegistry = converterRegistry;
    }

    @Override
    protected T postProcessEvent(Object o) {
        if (o == null) {
            return null;
        }
        if (this.converter == null) {
            this.converter = this.converterRegistry.resolveConverter(o);
        }
        if (this.converter != null) {
            return (T)((Serializable)this.converter.convert(o));
        }
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("Retrieved unsupported class {}.", (Object)o.getClass().getName());
        }
        return null;
    }
}

