/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.servlets;

import com.yammer.dropwizard.util.Servlets;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class ThreadNameFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        Thread current = Thread.currentThread();
        String oldName = current.getName();
        try {
            current.setName(ThreadNameFilter.formatName(req, oldName));
            chain.doFilter(request, response);
        }
        finally {
            current.setName(oldName);
        }
    }

    private static String formatName(HttpServletRequest req, String oldName) {
        return oldName + " - " + req.getMethod() + ' ' + Servlets.getFullUrl(req);
    }
}

