/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.logging;

import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.CoreConstants;

public class PrefixedThrowableProxyConverter
extends ThrowableProxyConverter {
    private static final String PREFIX = "! ";

    protected String throwableProxyToString(IThrowableProxy tp) {
        StringBuilder buf = new StringBuilder(32);
        for (IThrowableProxy currentThrowable = tp; currentThrowable != null; currentThrowable = currentThrowable.getCause()) {
            this.subjoinThrowableProxy(buf, currentThrowable);
        }
        return buf.toString();
    }

    void subjoinThrowableProxy(StringBuilder buf, IThrowableProxy tp) {
        this.subjoinFirstLine(buf, tp);
        buf.append(CoreConstants.LINE_SEPARATOR);
        StackTraceElementProxy[] stepArray = tp.getStackTraceElementProxyArray();
        int commonFrames = tp.getCommonFrames();
        int maxIndex = stepArray.length;
        if (commonFrames > 0) {
            maxIndex -= commonFrames;
        }
        for (int i = 0; i < maxIndex; ++i) {
            String string = stepArray[i].toString();
            buf.append(PREFIX);
            buf.append(string);
            this.extraData(buf, stepArray[i]);
            buf.append(CoreConstants.LINE_SEPARATOR);
        }
        if (commonFrames > 0) {
            buf.append("!... ").append(tp.getCommonFrames()).append(" common frames omitted").append(CoreConstants.LINE_SEPARATOR);
        }
    }

    private void subjoinFirstLine(StringBuilder buf, IThrowableProxy tp) {
        int commonFrames = tp.getCommonFrames();
        if (commonFrames > 0) {
            buf.append("Caused by: ");
        }
        this.subjoinExceptionMessage(buf, tp);
    }

    private void subjoinExceptionMessage(StringBuilder buf, IThrowableProxy tp) {
        buf.append(PREFIX).append(tp.getClassName()).append(": ").append(tp.getMessage());
    }
}

