/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.jersey.params;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public abstract class AbstractParam<T> {
    private final T value;

    protected AbstractParam(String input) {
        try {
            this.value = this.parse(input);
        }
        catch (Exception e) {
            throw new WebApplicationException(this.error(input, e));
        }
    }

    protected Response error(String input, Exception e) {
        return Response.status((Response.Status)this.getErrorStatus()).entity((Object)this.errorMessage(input, e)).type(this.mediaType()).build();
    }

    protected MediaType mediaType() {
        return MediaType.TEXT_PLAIN_TYPE;
    }

    protected String errorMessage(String input, Exception e) {
        return String.format("Invalid parameter: %s (%s)", input, e.getMessage());
    }

    protected Response.Status getErrorStatus() {
        return Response.Status.BAD_REQUEST;
    }

    protected abstract T parse(String var1) throws Exception;

    public T get() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractParam that = (AbstractParam)obj;
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value.toString();
    }
}

