/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.stream.buffer.stax;

import com.sun.xml.stream.buffer.BaseBufferTestCase;
import com.sun.xml.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.stream.buffer.stax.StreamReaderBufferProcessor;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class StreamWriterBufferCreatorTest
extends BaseBufferTestCase {
    public void testSimple() throws Exception {
        MutableXMLStreamBuffer buffer = new MutableXMLStreamBuffer();
        XMLStreamWriter writer = buffer.createFromXMLStreamWriter();
        writer.writeStartDocument();
        writer.writeStartElement("foo");
        writer.writeCharacters("body");
        writer.writeEndElement();
        writer.writeEndDocument();
        StreamWriterBufferCreatorTest.assertTrue((boolean)buffer.isCreated());
        StreamReaderBufferProcessor reader = buffer.readAsXMLStreamReader();
        StreamWriterBufferCreatorTest.assertEquals((int)7, (int)reader.getEventType());
        StreamWriterBufferCreatorTest.assertEquals((int)1, (int)reader.next());
        StreamWriterBufferCreatorTest.verifyTag((XMLStreamReader)((Object)reader), null, "foo");
        StreamWriterBufferCreatorTest.assertEquals((int)4, (int)reader.next());
        StreamWriterBufferCreatorTest.assertEquals((String)"body", (String)reader.getText());
        StreamWriterBufferCreatorTest.assertEquals((int)2, (int)reader.next());
        StreamWriterBufferCreatorTest.verifyTag((XMLStreamReader)((Object)reader), null, "foo");
    }

    public void testNamespaces() throws Exception {
        MutableXMLStreamBuffer buffer = new MutableXMLStreamBuffer();
        XMLStreamWriter writer = buffer.createFromXMLStreamWriter();
        writer.writeStartDocument();
        writer.setDefaultNamespace("http://default");
        writer.setPrefix("ns1", "http://ns1");
        writer.setPrefix("ns2", "http://ns2");
        StreamWriterBufferCreatorTest.assertEquals((String)"", (String)writer.getPrefix("http://default"));
        StreamWriterBufferCreatorTest.assertEquals((String)"ns1", (String)writer.getPrefix("http://ns1"));
        StreamWriterBufferCreatorTest.assertEquals((String)"ns2", (String)writer.getPrefix("http://ns2"));
        writer.writeStartElement("foo");
        writer.writeDefaultNamespace("http://default");
        writer.writeNamespace("ns1", "http://ns1");
        writer.writeNamespace("ns2", "http://ns2");
        writer.setDefaultNamespace("http://default-new");
        writer.setPrefix("ns2", "http://ns2-new");
        writer.setPrefix("ns3", "http://ns3");
        writer.setPrefix("ns4", "http://ns4");
        StreamWriterBufferCreatorTest.assertEquals((String)"", (String)writer.getPrefix("http://default-new"));
        StreamWriterBufferCreatorTest.assertEquals((String)"ns1", (String)writer.getPrefix("http://ns1"));
        StreamWriterBufferCreatorTest.assertEquals((String)"ns2", (String)writer.getPrefix("http://ns2-new"));
        StreamWriterBufferCreatorTest.assertEquals((String)"ns3", (String)writer.getPrefix("http://ns3"));
        StreamWriterBufferCreatorTest.assertEquals((String)"ns4", (String)writer.getPrefix("http://ns4"));
        writer.writeStartElement("bar");
        writer.writeDefaultNamespace("http://default-new");
        writer.writeNamespace("ns2", "http://ns2-new");
        writer.writeNamespace("ns3", "http://ns3");
        writer.writeNamespace("ns4", "http://ns4");
        writer.writeEndElement();
        writer.writeEndElement();
        StreamWriterBufferCreatorTest.assertEquals(null, (String)writer.getPrefix("http://ns3"));
        StreamWriterBufferCreatorTest.assertEquals(null, (String)writer.getPrefix("http://ns4"));
        StreamWriterBufferCreatorTest.assertEquals((String)"", (String)writer.getPrefix("http://default"));
        writer.writeEndDocument();
        StreamReaderBufferProcessor reader = buffer.readAsXMLStreamReader();
        StreamWriterBufferCreatorTest.assertEquals((int)7, (int)reader.getEventType());
        StreamWriterBufferCreatorTest.assertEquals((int)1, (int)reader.next());
        StreamWriterBufferCreatorTest.assertEquals((String)"http://default", (String)reader.getNamespaceURI(""));
        StreamWriterBufferCreatorTest.assertEquals((String)"http://ns1", (String)reader.getNamespaceURI("ns1"));
        StreamWriterBufferCreatorTest.assertEquals((String)"http://ns2", (String)reader.getNamespaceURI("ns2"));
        StreamWriterBufferCreatorTest.assertEquals((int)3, (int)reader.getNamespaceCount());
        StreamWriterBufferCreatorTest.verifyTag((XMLStreamReader)((Object)reader), "http://default", "foo");
        StreamWriterBufferCreatorTest.assertEquals((int)1, (int)reader.next());
        StreamWriterBufferCreatorTest.assertEquals((String)"http://default-new", (String)reader.getNamespaceURI(""));
        StreamWriterBufferCreatorTest.assertEquals((String)"http://ns1", (String)reader.getNamespaceURI("ns1"));
        StreamWriterBufferCreatorTest.assertEquals((String)"http://ns2-new", (String)reader.getNamespaceURI("ns2"));
        StreamWriterBufferCreatorTest.assertEquals((String)"http://ns3", (String)reader.getNamespaceURI("ns3"));
        StreamWriterBufferCreatorTest.assertEquals((String)"http://ns4", (String)reader.getNamespaceURI("ns4"));
        StreamWriterBufferCreatorTest.assertEquals((int)4, (int)reader.getNamespaceCount());
        StreamWriterBufferCreatorTest.verifyTag((XMLStreamReader)((Object)reader), "http://default-new", "bar");
        StreamWriterBufferCreatorTest.assertEquals((int)2, (int)reader.next());
        StreamWriterBufferCreatorTest.assertEquals((String)"http://default-new", (String)reader.getNamespaceURI(""));
        StreamWriterBufferCreatorTest.assertEquals((String)"http://ns1", (String)reader.getNamespaceURI("ns1"));
        StreamWriterBufferCreatorTest.assertEquals((String)"http://ns2-new", (String)reader.getNamespaceURI("ns2"));
        StreamWriterBufferCreatorTest.assertEquals((String)"http://ns3", (String)reader.getNamespaceURI("ns3"));
        StreamWriterBufferCreatorTest.assertEquals((String)"http://ns4", (String)reader.getNamespaceURI("ns4"));
        StreamWriterBufferCreatorTest.assertEquals((int)4, (int)reader.getNamespaceCount());
        StreamWriterBufferCreatorTest.verifyTag((XMLStreamReader)((Object)reader), "http://default-new", "bar");
        StreamWriterBufferCreatorTest.assertEquals((int)2, (int)reader.next());
        StreamWriterBufferCreatorTest.assertEquals((String)"http://default", (String)reader.getNamespaceURI(""));
        StreamWriterBufferCreatorTest.assertEquals((String)"http://ns1", (String)reader.getNamespaceURI("ns1"));
        StreamWriterBufferCreatorTest.assertEquals((String)"http://ns2", (String)reader.getNamespaceURI("ns2"));
        StreamWriterBufferCreatorTest.assertEquals(null, (String)reader.getNamespaceURI("ns3"));
        StreamWriterBufferCreatorTest.assertEquals(null, (String)reader.getNamespaceURI("ns4"));
        StreamWriterBufferCreatorTest.assertEquals((int)3, (int)reader.getNamespaceCount());
        StreamWriterBufferCreatorTest.verifyTag((XMLStreamReader)((Object)reader), "http://default", "foo");
        StreamWriterBufferCreatorTest.assertEquals((int)8, (int)reader.next());
        StreamWriterBufferCreatorTest.assertEquals(null, (String)reader.getNamespaceURI(""));
        StreamWriterBufferCreatorTest.assertEquals(null, (String)reader.getNamespaceURI("ns1"));
        StreamWriterBufferCreatorTest.assertEquals(null, (String)reader.getNamespaceURI("ns2"));
    }
}

