/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.http.server;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpsExchange;
import com.sun.xml.ws.handler.MessageContextImpl;
import com.sun.xml.ws.handler.MessageContextUtil;
import com.sun.xml.ws.server.DocInfo;
import com.sun.xml.ws.server.RuntimeEndpointInfo;
import com.sun.xml.ws.server.Tie;
import com.sun.xml.ws.server.WSDLPatcher;
import com.sun.xml.ws.spi.runtime.WSConnection;
import com.sun.xml.ws.spi.runtime.WebServiceContext;
import com.sun.xml.ws.transport.Headers;
import com.sun.xml.ws.transport.http.server.ServerConnectionImpl;
import com.sun.xml.ws.util.localization.LocalizableMessageFactory;
import com.sun.xml.ws.util.localization.Localizer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class WSHttpHandler
implements HttpHandler {
    private static final String GET_METHOD = "GET";
    private static final String POST_METHOD = "POST";
    private static final String HTML_CONTENT_TYPE = "text/html";
    private static final String XML_CONTENT_TYPE = "text/xml";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.server.http");
    private static final Localizer localizer = new Localizer();
    private static final LocalizableMessageFactory messageFactory = new LocalizableMessageFactory("com.sun.xml.ws.resources.httpserver");
    private RuntimeEndpointInfo endpointInfo;
    private Tie tie;

    public WSHttpHandler(Tie tie, RuntimeEndpointInfo endpointInfo) {
        this.tie = tie;
        this.endpointInfo = endpointInfo;
    }

    public void handle(HttpExchange msg) {
        logger.fine("Received HTTP request:" + msg.getRequestURI());
        String method = msg.getRequestMethod();
        if (method.equals(GET_METHOD)) {
            String queryString = msg.getRequestURI().getQuery();
            logger.fine("Query String for request =" + queryString);
            if (queryString != null && (queryString.equals("wsdl") || queryString.startsWith("wsdl=") || queryString.startsWith("xsd="))) {
                this.processDocRequest(msg);
            } else {
                this.process(msg);
            }
        } else if (method.equals(POST_METHOD)) {
            this.process(msg);
        } else {
            logger.warning(localizer.localize(messageFactory.getMessage("unexpected.http.method", method)));
            try {
                msg.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(HttpExchange msg) {
        ServerConnectionImpl con = new ServerConnectionImpl(msg);
        try {
            MessageContextImpl msgCtxt = new MessageContextImpl();
            WebServiceContext wsContext = this.endpointInfo.getWebServiceContext();
            wsContext.setMessageContext(msgCtxt);
            MessageContextUtil.setHttpRequestMethod(msgCtxt, msg.getRequestMethod());
            MessageContextUtil.setHttpRequestHeaders(msgCtxt, con.getHeaders());
            MessageContextUtil.setHttpExchange(msgCtxt, msg);
            URI requestUri = msg.getRequestURI();
            String query = requestUri.getQuery();
            if (query != null) {
                MessageContextUtil.setQueryString(msgCtxt, query);
            }
            String reqPath = requestUri.getPath();
            String ctxtPath = msg.getHttpContext().getPath();
            if (reqPath.length() > ctxtPath.length()) {
                String extraPath = reqPath.substring(ctxtPath.length());
                MessageContextUtil.setPathInfo(msgCtxt, extraPath);
            }
            this.tie.handle(con, this.endpointInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDocRequest(HttpExchange msg) {
        ServerConnectionImpl con = new ServerConnectionImpl(msg);
        try {
            con.getInput();
            String queryString = msg.getRequestURI().getQuery();
            String inPath = this.endpointInfo.getPath(queryString);
            if (inPath == null) {
                String message = localizer.localize(messageFactory.getMessage("html.notFound", "Invalid Request =" + msg.getRequestURI()));
                this.writeErrorPage(con, 404, message);
                return;
            }
            DocInfo docInfo = this.endpointInfo.getDocMetadata().get(inPath);
            if (docInfo == null) {
                String message = localizer.localize(messageFactory.getMessage("html.notFound", "Invalid Request =" + msg.getRequestURI()));
                this.writeErrorPage(con, 404, message);
                return;
            }
            InputStream docStream = null;
            try {
                Map<String, List<String>> reqHeaders = con.getHeaders();
                List<String> hostHeader = reqHeaders.get("Host");
                Headers respHeaders = new Headers();
                respHeaders.add(CONTENT_TYPE_HEADER, XML_CONTENT_TYPE);
                con.setHeaders(respHeaders);
                con.setStatus(200);
                OutputStream os = con.getOutput();
                ArrayList<RuntimeEndpointInfo> endpoints = new ArrayList<RuntimeEndpointInfo>();
                endpoints.add(this.endpointInfo);
                StringBuffer strBuf = new StringBuffer();
                strBuf.append(msg instanceof HttpsExchange ? "https" : "http");
                strBuf.append("://");
                if (hostHeader != null) {
                    strBuf.append(hostHeader.get(0));
                } else {
                    strBuf.append(msg.getLocalAddress().getHostName());
                    strBuf.append(":");
                    strBuf.append(msg.getLocalAddress().getPort());
                }
                strBuf.append(msg.getRequestURI().getPath());
                String address = strBuf.toString();
                logger.fine("Address =" + address);
                WSDLPatcher patcher = new WSDLPatcher(docInfo, address, this.endpointInfo, endpoints);
                docStream = docInfo.getDoc();
                patcher.patchDoc(docStream, os);
            }
            catch (Throwable throwable) {
                WSHttpHandler.closeInputStream(docStream);
                con.closeOutput();
                throw throwable;
            }
            WSHttpHandler.closeInputStream(docStream);
            con.closeOutput();
        }
        finally {
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeErrorPage(WSConnection con, int status, String message) {
        try {
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
            ArrayList<String> ctHeader = new ArrayList<String>();
            ctHeader.add(HTML_CONTENT_TYPE);
            headers.put(CONTENT_TYPE_HEADER, ctHeader);
            con.setHeaders(headers);
            con.setStatus(status);
            OutputStream outputStream = con.getOutput();
            PrintWriter out = new PrintWriter(outputStream);
            out.println("<html><head><title>");
            out.println(localizer.localize(messageFactory.getMessage("html.title", new Object[0])));
            out.println("</title></head><body>");
            out.println(message);
            out.println("</body></html>");
            out.close();
        }
        finally {
            con.closeOutput();
        }
    }

    private static void closeInputStream(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

