/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.http.server;

import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.server.RuntimeEndpointInfo;
import com.sun.xml.ws.transport.http.server.HttpEndpoint;
import java.security.Permission;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.xml.transform.Source;
import javax.xml.ws.Binding;
import javax.xml.ws.Endpoint;
import javax.xml.ws.WebServicePermission;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointImpl
extends Endpoint {
    private static final WebServicePermission ENDPOINT_PUBLISH_PERMISSION = new WebServicePermission("publishEndpoint");
    private Object actualEndpoint;
    private RuntimeEndpointInfo rtEndpointInfo = new RuntimeEndpointInfo();

    public EndpointImpl(String bindingId, Object impl) {
        this.rtEndpointInfo.setImplementor(impl);
        this.rtEndpointInfo.setImplementorClass(impl.getClass());
        com.sun.xml.ws.spi.runtime.Binding binding = BindingImpl.getBinding(bindingId, impl.getClass(), null, false);
        this.rtEndpointInfo.setBinding(binding);
    }

    public Binding getBinding() {
        return this.rtEndpointInfo.getBinding();
    }

    public Object getImplementor() {
        return this.rtEndpointInfo.getImplementor();
    }

    public void publish(String address) {
        this.checkPlatform();
        ((HttpEndpoint)this.actualEndpoint).publish(address);
    }

    public void publish(Object serverContext) {
        this.checkPlatform();
        ((HttpEndpoint)this.actualEndpoint).publish(serverContext);
    }

    public void stop() {
        ((HttpEndpoint)this.actualEndpoint).stop();
    }

    public boolean isPublished() {
        return this.rtEndpointInfo.isDeployed();
    }

    public List<Source> getMetadata() {
        return this.rtEndpointInfo.getMetadata();
    }

    public void setMetadata(List<Source> metadata) {
        if (this.isPublished()) {
            throw new IllegalStateException("Cannot set Metadata. Already published");
        }
        this.rtEndpointInfo.setMetadata(metadata);
    }

    public Executor getExecutor() {
        return this.rtEndpointInfo.getExecutor();
    }

    public void setExecutor(Executor executor) {
        this.rtEndpointInfo.setExecutor(executor);
    }

    public Map<String, Object> getProperties() {
        return this.rtEndpointInfo.getProperties();
    }

    public void setProperties(Map<String, Object> map) {
        this.rtEndpointInfo.setProperties(map);
    }

    private void checkPlatform() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)ENDPOINT_PUBLISH_PERMISSION);
        }
        try {
            Class.forName("com.sun.net.httpserver.HttpServer");
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("NOT SUPPORTED");
        }
        this.actualEndpoint = new HttpEndpoint(this.rtEndpointInfo);
    }
}

