/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Grizzly {
    private static final Pattern versionPattern = Pattern.compile("((\\d+)\\.(\\d+)\\.(\\d+)){1}(.+)?");
    private static String dotedVersion;
    private static int major;
    private static int minor;
    private static int micro;
    private static String version;
    private static String serverName;

    public static void main(String[] args) {
        System.out.println(Grizzly.getDotedVersion());
    }

    private static void populate() {
        Matcher matcher = versionPattern.matcher(version);
        if (matcher.matches()) {
            dotedVersion = matcher.group(1);
            major = Integer.parseInt(matcher.group(2));
            minor = Integer.parseInt(matcher.group(3));
            micro = Integer.parseInt(matcher.group(4));
        } else {
            dotedVersion = "no.version";
            major = -1;
            minor = -1;
            micro = -1;
        }
        if (serverName == null) {
            serverName = "Grizzly/" + Grizzly.getRawVersion();
        }
    }

    public static String getRawVersion() {
        return version;
    }

    public static String getDotedVersion() {
        return dotedVersion;
    }

    public static int getMajorVersion() {
        return major;
    }

    public static int getMinorVersion() {
        return minor;
    }

    public static int getMicroVersion() {
        return micro;
    }

    public static void setRawVersion(String s) {
        version = s;
        Grizzly.populate();
    }

    public static boolean equalVersion(int major, int minor) {
        return minor == Grizzly.minor && major == Grizzly.major;
    }

    public static void setServerInfo(String s) {
        serverName = s;
    }

    public static String getServerInfo() {
        return serverName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream is = null;
        Properties prop = new Properties();
        try {
            is = Grizzly.class.getResourceAsStream("version.properties");
            prop.load(is);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        version = prop.getProperty("grizzly.version");
        Grizzly.populate();
    }
}

