/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import java.io.IOException;
import java.net.BindException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PortRange {
    private static final Pattern FORMAT = Pattern.compile("(\\d+)(?:(?:,|:)(\\d+))?");
    private final int lower;
    private final int upper;
    private static final Random _random = new Random();

    public PortRange(int low, int high) {
        if (low < 0 || high < low || 65535 < high) {
            throw new IllegalArgumentException("Invalid range");
        }
        this.lower = low;
        this.upper = high;
    }

    public PortRange(int port) {
        this(port, port);
    }

    public static PortRange valueOf(String s) throws IllegalArgumentException {
        try {
            Matcher m = FORMAT.matcher(s);
            if (!m.matches()) {
                throw new IllegalArgumentException("Invalid range: " + s);
            }
            int low = Integer.parseInt(m.group(1));
            int high = m.groupCount() == 1 ? low : Integer.parseInt(m.group(2));
            return new PortRange(low, high);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid range: " + s);
        }
    }

    public int random() {
        return _random.nextInt(this.upper - this.lower + 1) + this.lower;
    }

    public int succ(int port) {
        return port < this.upper ? port + 1 : this.lower;
    }

    public int getLower() {
        return this.lower;
    }

    public int getUpper() {
        return this.upper;
    }

    public void bind(ServerSocket socket, InetSocketAddress endpoint, int backLog) throws IOException {
        int port = endpoint.getPort();
        PortRange range = port > 0 ? new PortRange(port) : this;
        range.bind(socket, endpoint.getAddress(), backLog);
    }

    public void bind(Socket socket, InetSocketAddress endpoint) throws IOException {
        int port = endpoint.getPort();
        PortRange range = port > 0 ? new PortRange(port) : this;
        range.bind(socket, endpoint.getAddress());
    }

    public void bind(ServerSocket socket, InetAddress address, int backLog) throws IOException {
        int start;
        int port = start = this.random();
        while (true) {
            try {
                socket.bind(new InetSocketAddress(address, port), backLog);
                return;
            }
            catch (BindException e) {
                if ((port = this.succ(port)) != start) continue;
                throw new BindException("No free port within range");
            }
            break;
        }
    }

    public void bind(Socket socket, InetAddress address) throws IOException {
        int start;
        int port = start = this.random();
        while (true) {
            try {
                socket.bind(new InetSocketAddress(address, port));
                return;
            }
            catch (BindException e) {
                if ((port = this.succ(port)) != start) continue;
                throw new BindException("No free port within range");
            }
            break;
        }
    }

    public void bind(DatagramSocket socket, InetAddress address) throws IOException {
        int start;
        int port = start = this.random();
        while (true) {
            try {
                socket.bind(new InetSocketAddress(address, port));
                return;
            }
            catch (BindException e) {
                if ((port = this.succ(port)) != start) continue;
                throw new BindException("No free port within range");
            }
            break;
        }
    }

    public void bind(DatagramSocket socket) throws IOException {
        this.bind(socket, (InetAddress)null);
    }

    public void bind(ServerSocket socket, int backLog) throws IOException {
        this.bind(socket, (InetAddress)null, 50);
    }

    public void bind(Socket socket) throws IOException {
        this.bind(socket, (InetAddress)null);
    }

    public String toString() {
        return String.format("%d:%d", this.lower, this.upper);
    }
}

