/*
 * Decompiled with CFR 0.152.
 */
package com.streamsets.pipeline.api.base;

import com.streamsets.pipeline.api.Batch;
import com.streamsets.pipeline.api.BatchMaker;
import com.streamsets.pipeline.api.Processor;
import com.streamsets.pipeline.api.Record;
import com.streamsets.pipeline.api.StageException;
import com.streamsets.pipeline.api.base.BaseProcessor;
import com.streamsets.pipeline.api.base.OnRecordErrorException;
import com.streamsets.pipeline.api.impl.Utils;
import java.util.Iterator;

public abstract class RecordProcessor
extends BaseProcessor {
    @Override
    public void process(Batch batch, BatchMaker batchMaker) throws StageException {
        Iterator<Record> it = batch.getRecords();
        if (it.hasNext()) {
            block7: while (it.hasNext()) {
                Record record = it.next();
                try {
                    this.process(record, batchMaker);
                }
                catch (OnRecordErrorException ex) {
                    switch (((Processor.Context)this.getContext()).getOnErrorRecord()) {
                        case DISCARD: {
                            continue block7;
                        }
                        case TO_ERROR: {
                            ((Processor.Context)this.getContext()).toError(record, ex);
                            continue block7;
                        }
                        case STOP_PIPELINE: {
                            throw ex;
                        }
                    }
                    throw new IllegalStateException(Utils.format("It should never happen. OnError '{}'", ((Processor.Context)this.getContext()).getOnErrorRecord(), ex));
                }
            }
        } else {
            this.emptyBatch(batchMaker);
        }
    }

    protected abstract void process(Record var1, BatchMaker var2) throws StageException;

    protected void emptyBatch(BatchMaker batchMaker) throws StageException {
    }
}

